package com.yd.rmi.n22.staff.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.yd.rmi.cache.SystemConfigService;
import com.yd.rmi.n22.common.utils.N22Utils;
import com.yd.rmi.n22.policy.service.impl.N22PolicyServiceImpl;
import com.yd.rmi.n22.staff.pojo.GetStaffNewRequestBody;
import com.yd.rmi.n22.staff.pojo.GetStaffNewResponseVO;
import com.yd.rmi.n22.staff.pojo.Staff;
import com.yd.rmi.n22.staff.service.N22StaffService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.UUID;

@Service
public class N22StaffServiceImpl implements N22StaffService {

    @Autowired
    private SystemConfigService systemConfigService;

    @Override
    public GetStaffNewResponseVO getStaffNew(GetStaffNewRequestBody getStaffNewRequestBody) {

        JSONObject obj = new JSONObject(); //传参

        JSONObject requestHead = new JSONObject();
        requestHead.put("seqNo", UUID.randomUUID().toString());

        obj.put("requestHead", requestHead);
        obj.put("requestBody", getStaffNewRequestBody);

        String url = systemConfigService.getSingleConfigValue("N22_URL_Get_Staff_New");
        String result = N22Utils.postTransaction(url, obj.toString());

        GetStaffNewResponseVO response = JSONObject.parseObject(result, GetStaffNewResponseVO.class);

        return response;
    }

    @Override
    public String queryN22LoginNameByMobileNo(String mobileNo) {
        // 根据手机号查询经纪人在N22系统的Agent_id
        GetStaffNewRequestBody getStaffNewRequestBody = new GetStaffNewRequestBody();
        getStaffNewRequestBody.setMobile(mobileNo);

        GetStaffNewResponseVO resp = this.getStaffNew(getStaffNewRequestBody);

        String agent_id = null;
        if(resp != null){
            if ("查询成功".equals(resp.getResponseHead().getMessage())){
                List<Staff> staffList = resp.getResponseBody().getStaff();
                if (staffList.size() > 0) {
                    Staff staff = staffList.get(0);
                    agent_id = staff.getAgent_id();
                }
            }
        }
        return agent_id;
    }
}
