package com.yd.dal.mapper.customer;

import com.yd.api.practitioner.vo.payscale.PayScaleInfo;import com.yd.api.practitioner.vo.subordinate.TeamMemberDetail;import com.yd.dal.entity.customer.AclPractitioner;
import java.util.List;
import com.yd.dal.entity.customer.practitioner.PractitionerBasicInfo;import com.yd.dal.entity.customer.practitioner.PractitionerInfo;import com.yd.dal.entity.customer.practitioner.PractitionerRankInfo;import com.yd.dal.entity.practitioner.opportunity.OwnOpportunityInfo;import com.yd.dal.entity.practitioner.opportunity.PlayerSalesActivityInfo;import com.yd.dal.entity.practitioner.payscale.PayScaleBasicInfo;import org.apache.ibatis.annotations.Param;

public interface AclPractitionerMapper {
    int deleteByPrimaryKey(Long id);

    int insert(AclPractitioner record);

    int insertSelective(AclPractitioner record);

    AclPractitioner selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(AclPractitioner record);

    int updateByPrimaryKey(AclPractitioner record);

    int updateBatch(List<AclPractitioner> list);

    int updateBatchSelective(List<AclPractitioner> list);

    int batchInsert(@Param("list") List<AclPractitioner> list);

    PractitionerBasicInfo getPractitionerInfoByMobileNoForOffline(String mobileNo);

    List<PractitionerRankInfo> getPractitionerRankInfoForOffline(@Param("time") Integer time);

    PractitionerBasicInfo getPractitionerInfoByMobileNoForOnline(String mobileNo);

    List<PractitionerRankInfo> getPractitionerRankInfoForOnline(@Param("time") Integer time, @Param("practitionerTypeId") Long practitionerTypeId);

    List<PractitionerRankInfo> getPractitionerRankInfoForSpecials(@Param("mobileSpecials") List<String> mobileSpecials, @Param("time") Integer time);

    PractitionerInfo findPractitionerInfoByLogin(@Param("mobileNo") String mobileNo);

    AclPractitioner findByCustomerIdIsActive(@Param("customerId") Long customerId, @Param("isActive") int isActive);

    List<OwnOpportunityInfo> ownOpportunityQuery(@Param("practitionerId") Long practitionerId);

    List<AclPractitioner> findByIds(@Param("practitionerIdList") List<Long> practitionerIdList);

    List<AclPractitioner> findForSubordinateIdByPractitionerId(Long practitionerId);

    List<PlayerSalesActivityInfo> playerSalesActivityQuery(@Param("practitionerId") Long practitionerId, @Param("optionsId") Long optionsId);

    List<AclPractitioner> findBySubordinateSystemId(@Param("subordinateSystemId") Long subordinateSystemId);

    String findMobileNoByPractitionerId(@Param("practitionerId") Long practitionerId);

    PractitionerBasicInfo findByMobileNoE(@Param("mobileNo") String mobileNo);

    PractitionerRankInfo getPractitionerRankInfoByPractitionerIdEG(@Param("practitionerIdEG") String practitionerIdEG, @Param("time") Integer time);

    PractitionerRankInfo getPractitionerRankInfoByPractitionerIdYD(@Param("practitionerId") Long practitionerId, @Param("time") Integer time);

    List<PayScaleInfo> findPayScaleByPractitionerEG(@Param("practitionerIdEG") String practitionerIdEG);

    PayScaleBasicInfo findFilePathByMonShId(@Param("monShId") Integer monShId);

    PractitionerBasicInfo findByIdEG(@Param("practitionerIdEG") String practitionerIdEG);

    AclPractitioner findPractitionerByLeadsAssignedId(Long leadsAssignedId);

    List<AclPractitioner> findAll();

    int isTeamLeader(Long practitionerId);

    List<Long> queryTeamAllPractitionerId(@Param("practitionerId")Long practitionerId,@Param("isActive")Integer isActive);

    List<Long> queryMentoredByPractitionerId(Long practitionerId);

    PractitionerInfo findPractitionerInfoByPractitionerId(Long practitionerId);

    AclPractitioner selectByMobileNo(String mobileNo);

    List<TeamMemberDetail> queryTeamMemberDetailList(List<Long> practitionerIdList);

    List<String> findLeaveOfficeByPractitionerId(Long practitionerId);

    List<AclPractitioner> queryAllLifePractitioner();

}