package com.yd.dal.service.agms;

import com.yd.api.agms.vo.fortune.CommissionPayoutAddRemarkRequestVO;
import com.yd.dal.entity.agms.fortune.*;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author xxy
 */
public interface AgmsFortuneDALService {
    /**
     * 通过customerid查询财富基本信息(历史累积财富  已退保财富  已提现财富 等)
     * @param customerIds customerIds
     * @return 财富基本信息(历史累积财富  已退保财富  已提现财富 等)
     */
    Map<Long,CustomerFortuneStatisticalInfo> findFortuneStatisticalByCustomers(Set<Long> customerIds);

    /**
     * 发佣检核列表
     * @param requestVO 过滤条件
     * @return 返回结果
     */
    List<CommissionPayoutStatus> commissionPayoutStatusQuery(CommissionPayoutStatusQueryInfo requestVO);

    /**
     * 通过customerId和payId查询fortune记录
     * @param payId payId
     * @return FortunePayToOrderInfo
     */
    List<FortunePayToOrderInfo> fortunePayToOrder(Long[] payId);

    /**
     * 支付列表插叙
     * @param info info
     * @return WithdrawLabelInfo
     */
    List<WithdrawLabelInfo> transformForWithdrawLabel(WithdrawQueryInfo info);

    /**
     * 薪资单保单明细
     * @param info 过滤条件
     * @return 返回结果
     */
    List<WithdrawLabelInfo> salaryPolicyNoDetails(WithdrawQueryInfo info);

    List<Map<String, Object>> querySheet2Data(List<Long> fortuneIdList, List<Long> fortuneIdList2);

    List<Long> querySalePractitionerFortune(List<Long> fortuneIdList);

    List<Long> querySalePractitionerFortune1(List<Long> fortuneIdList);

    void commissionPayoutAddRemark(CommissionPayoutAddRemarkRequestVO requestVO);
}
