/*
 * Decompiled with CFR 0.152.
 */
package com.libs.pdf;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PDFWithTable {
    public static void creatPdf(Map<String, Object> map, String templateFilePath, String outFilePath) {
        try {
            Map listMap;
            int pageNo;
            Map imgmap;
            BaseFont bf = BaseFont.createFont((String)"c://windows//fonts//simsun.ttc,1", (String)"Identity-H", (boolean)true);
            FileOutputStream out = new FileOutputStream(outFilePath);
            PdfReader reader = new PdfReader(templateFilePath);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PdfStamper stamper = new PdfStamper(reader, (OutputStream)bos);
            stamper.setFormFlattening(true);
            AcroFields form = stamper.getAcroFields();
            Map datemap = (Map)map.get("datamap");
            if (datemap != null) {
                form.addSubstitutionFont(bf);
                for (Object key : datemap.keySet()) {
                    String value = (String)datemap.get(key);
                    form.setField((String)key, value);
                }
            }
            if ((imgmap = (Map)map.get("imgmap")) != null) {
                for (Object key : imgmap.keySet()) {
                    String value;
                    String imgpath = value = (String)imgmap.get(key);
                    pageNo = ((AcroFields.FieldPosition)form.getFieldPositions((String)key).get((int)0)).page;
                    Rectangle signRect = ((AcroFields.FieldPosition)form.getFieldPositions((String)key).get((int)0)).position;
                    float x = signRect.getLeft();
                    float y = signRect.getBottom();
                    Image image = Image.getInstance((String)imgpath);
                    PdfContentByte under = stamper.getOverContent(pageNo);
                    image.scaleToFit(signRect.getWidth(), signRect.getHeight());
                    image.setAbsolutePosition(x, y);
                    under.addImage(image);
                }
            }
            if ((listMap = (Map)map.get("list")) != null) {
                for (String key : listMap.keySet()) {
                    List lists = (List)listMap.get(key);
                    pageNo = ((AcroFields.FieldPosition)form.getFieldPositions((String)key).get((int)0)).page;
                    PdfContentByte pcb = stamper.getOverContent(pageNo);
                    Rectangle signRect = ((AcroFields.FieldPosition)form.getFieldPositions((String)key).get((int)0)).position;
                    int column = ((List)lists.get(0)).size();
                    int row = ((List)lists.get(1)).size();
                    PdfPTable table = new PdfPTable(column);
                    table.setSplitLate(false);
                    table.setSplitRows(true);
                    float tatalWidth = signRect.getRight() - signRect.getLeft() - 1.0f;
                    int size = ((List)lists.get(0)).size();
                    float[] width = new float[size];
                    for (int i = 0; i < size; ++i) {
                        width[i] = i == 0 ? 60.0f : (tatalWidth - 60.0f) / (float)(size - 1);
                    }
                    table.setTotalWidth(width);
                    table.setLockedWidth(true);
                    table.setKeepTogether(true);
                    table.setSplitLate(false);
                    table.setSplitRows(true);
                    Font FontProve = new Font(bf, 10.0f, 0);
                    for (int i = 0; i < row / 2; ++i) {
                        List listData = (List)lists.get(1);
                        for (int j = 0; j < column; ++j) {
                            Paragraph paragraph = new Paragraph(String.valueOf(listData.get(2 * i + j)), FontProve);
                            PdfPCell cell = new PdfPCell((Phrase)paragraph);
                            cell.setBorderWidth(1.0f);
                            cell.setVerticalAlignment(1);
                            cell.setHorizontalAlignment(1);
                            cell.setLeading(0.0f, 1.4f);
                            table.addCell(cell);
                        }
                        table.writeSelectedRows(0, -1, signRect.getLeft(), signRect.getTop(), pcb);
                    }
                }
            }
            stamper.setFormFlattening(true);
            stamper.close();
            Document doc = new Document();
            PdfCopy copy = new PdfCopy(doc, (OutputStream)out);
            doc.open();
            int pageNum = reader.getNumberOfPages();
            for (int i = 1; i <= pageNum; ++i) {
                PdfImportedPage importPage = copy.getImportedPage(new PdfReader(bos.toByteArray()), i);
                copy.addPage(importPage);
            }
            doc.close();
        }
        catch (IOException e) {
            System.out.println(e);
        }
        catch (DocumentException e) {
            System.out.println((Object)e);
        }
    }

    public static void main(String[] args) throws Exception {
        String templatePDF = "D:\\pcs12\\EGolden\u85aa\u8d44\u6a21\u677fNew.pdf";
        String templateResultPDF = "D:\\pcs12\\\u85aa\u8d44\u5355\u8f93\u51fa.pdf";
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("table1Name", "table1Name\u6807\u9898\u52a02021-02-22 12:12:12");
        dataMap.put("table2Name", "table2Name\u6807\u9898\u52a02021-02-22 12:12:12");
        ArrayList<String> list = new ArrayList<String>();
        list.add("\u65e5\u671f");
        list.add("\u91d1\u989d");
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add("2018-01-01");
        list2.add("100");
        list2.add("2018-01-02");
        list2.add("101");
        list2.add("2018-01-03");
        list2.add("102");
        list2.add("2018-01-04");
        list2.add("103");
        list2.add("2018-01-05");
        list2.add("104");
        list2.add("2018-01-06");
        list2.add("105");
        list2.add("2018-01-07");
        list2.add("106");
        list2.add("2018-01-08");
        list2.add("107");
        list2.add("2018-01-09");
        list2.add("108");
        list2.add("2018-01-10");
        list2.add("109");
        list2.add("2018-01-11");
        list2.add("111");
        list2.add("2018-01-12");
        list2.add("112");
        list2.add("2018-01-13");
        list2.add("113");
        list2.add("2018-01-14");
        list2.add("114");
        list2.add("2018-01-15");
        list2.add("115");
        list2.add("2018-01-16");
        list2.add("109");
        list2.add("2018-01-17");
        list2.add("109");
        list2.add("2018-01-18");
        list2.add("109");
        list2.add("2018-01-19");
        list2.add("109");
        list2.add("2018-01-20");
        list2.add("109");
        list2.add("2018-01-21");
        list2.add("109");
        list2.add("2018-01-22");
        list2.add("109");
        list2.add("2018-01-23");
        list2.add("109");
        list2.add("2018-01-24");
        list2.add("109");
        list2.add("112");
        list2.add("2018-01-13");
        list2.add("113");
        list2.add("2018-01-14");
        list2.add("114");
        list2.add("2018-01-15");
        list2.add("115");
        list2.add("2018-01-16");
        list2.add("109");
        list2.add("2018-01-17");
        list2.add("109");
        list2.add("2018-01-18");
        list2.add("109");
        list2.add("2018-01-19");
        list2.add("109");
        list2.add("2018-01-20");
        list2.add("109");
        list2.add("2018-01-21");
        list2.add("109");
        list2.add("2018-01-22");
        list2.add("109");
        list2.add("2018-01-23");
        list2.add("109");
        list2.add("2018-01-24");
        list2.add("109");
        list2.add("112");
        list2.add("2018-01-13");
        list2.add("113");
        list2.add("2018-01-14");
        list2.add("114");
        list2.add("2018-01-15");
        list2.add("115");
        list2.add("2018-01-16");
        list2.add("109");
        list2.add("2018-01-17");
        list2.add("109");
        list2.add("2018-01-18");
        list2.add("109");
        list2.add("2018-01-19");
        list2.add("109");
        list2.add("2018-01-20");
        list2.add("109");
        list2.add("2018-01-21");
        list2.add("109");
        list2.add("2018-01-22");
        list2.add("109");
        list2.add("2018-01-23");
        list2.add("109");
        list2.add("2018-01-24");
        list2.add("109");
        ArrayList<ArrayList<String>> List2 = new ArrayList<ArrayList<String>>();
        List2.add(list);
        List2.add(list2);
        HashMap<String, ArrayList<ArrayList<String>>> listMap = new HashMap<String, ArrayList<ArrayList<String>>>();
        listMap.put("table1", List2);
        HashMap<String, Object> o = new HashMap<String, Object>();
        o.put("datamap", dataMap);
        o.put("list", listMap);
        PDFWithTable.creatPdf(o, templatePDF, templateResultPDF);
    }
}

