package com.yd.dal.mapper.marketing;

import com.yd.dal.entity.practitioner.PersonalPEPScore;
import com.yd.dal.entity.practitioner.PersonalSchedule;
import com.yd.dal.entity.practitioner.ScheduleTrack;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

public interface ScheduleTrackMapper {

    void insert(ScheduleTrack schedule);

    List<ScheduleTrack> queryScheduleTrackList(@Param("practitionerId")Long practitionerId);

    int checkTimePeriodConflict(@Param("taskTimeFrom")String taskTimeFrom, @Param("taskTimeEnd")String taskTimeEnd,
                                @Param("practitionerId")Long practitionerId);

    List<PersonalPEPScore> querySaleRecuitScoreFYC(@Param("practitionerId")Long practitionerId, @Param("firstDay")Date firstDay,
                                                   @Param("lastDay")Date lastDay);

    List<Long> queryTeamAllPractitionerId(@Param("practitionerId")Long practitionerId);

    List<PersonalSchedule> queryPersonalScheduleList(List<Long> practitionerIdList);

    List<ScheduleTrack> queryPersonalScheduleListByTime(@Param("practitionerId")Long practitionerId, @Param("time")String time);

    void deleteScheduleTrackById(@Param("scheduleTrackId")Long scheduleTrackId);

    String queryNameByPractitionerId(Long practitionerId);
}

