package com.yd.dal.entity.commission;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * ag_po_order_commission
 * @author 
 */
public class AgPoOrderCommission implements Serializable {
    /**
     * serial id
     */
    private Long id;

    /**
     * 来佣编号
     */
    private String commissionNo;

    /**
     * 佣金类别(1=佣金; 2=公告佣金; 3=B2C佣金, 4=推荐佣金、以此类推N)
     */
    private Integer commissionType;

    /**
     * 经纪人customerID
     */
    private Long customerId;

    /**
     * practitioner_id
     */
    private Long practitionerId;

    /**
     * 订单ID
     */
    private Long orderId;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 预计来佣时间(用于查询与结算)
     */
    private Date commissionYear;

    /**
     * 缴费年限
     */
    private Integer paymentTerm;

    /**
     * 保费
     */
    private BigDecimal premium;

    /**
     * 来佣项目;0=首年佣金; 1=续年佣金
     */
    private String commissionCategory;

    /**
     * 旧的费用率
     */
    private BigDecimal oldrate;

    /**
     * 最新费用率
     */
    private BigDecimal rate;

    /**
     * 来佣金额
     */
    private BigDecimal amount;

    /**
     * 来佣结算状态,0=未结算; 1=已结算;
     */
    private String commissionStatus;

    /**
     * 结算时间
     */
    private String commissionTime;

    /**
     * 佣金期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)
     */
    private Integer commissionPeriod;

    /**
     * FK ag_po_order_commission_check.id
     */
    private Long commissionCheckId;

    /**
     * 1=active 2=inactive
     */
    private Integer isActive;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    private Date createdAt;

    /**
     * FK ag_acl_user.id
     */
    private Long createdBy;

    /**
     * 修改时间
     */
    private Date updatedAt;

    /**
     * FK ag_acl_user.id
     */
    private Long updatedBy;

    private static final long serialVersionUID = 1L;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCommissionNo() {
        return commissionNo;
    }

    public void setCommissionNo(String commissionNo) {
        this.commissionNo = commissionNo;
    }

    public Integer getCommissionType() {
        return commissionType;
    }

    public void setCommissionType(Integer commissionType) {
        this.commissionType = commissionType;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public Long getPractitionerId() {
        return practitionerId;
    }

    public void setPractitionerId(Long practitionerId) {
        this.practitionerId = practitionerId;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public String getPolicyNo() {
        return policyNo;
    }

    public void setPolicyNo(String policyNo) {
        this.policyNo = policyNo;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public Date getCommissionYear() {
        return commissionYear;
    }

    public void setCommissionYear(Date commissionYear) {
        this.commissionYear = commissionYear;
    }

    public Integer getPaymentTerm() {
        return paymentTerm;
    }

    public void setPaymentTerm(Integer paymentTerm) {
        this.paymentTerm = paymentTerm;
    }

    public BigDecimal getPremium() {
        return premium;
    }

    public void setPremium(BigDecimal premium) {
        this.premium = premium;
    }

    public String getCommissionCategory() {
        return commissionCategory;
    }

    public void setCommissionCategory(String commissionCategory) {
        this.commissionCategory = commissionCategory;
    }

    public BigDecimal getOldrate() {
        return oldrate;
    }

    public void setOldrate(BigDecimal oldrate) {
        this.oldrate = oldrate;
    }

    public BigDecimal getRate() {
        return rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getCommissionStatus() {
        return commissionStatus;
    }

    public void setCommissionStatus(String commissionStatus) {
        this.commissionStatus = commissionStatus;
    }

    public String getCommissionTime() {
        return commissionTime;
    }

    public void setCommissionTime(String commissionTime) {
        this.commissionTime = commissionTime;
    }

    public Integer getCommissionPeriod() {
        return commissionPeriod;
    }

    public void setCommissionPeriod(Integer commissionPeriod) {
        this.commissionPeriod = commissionPeriod;
    }

    public Long getCommissionCheckId() {
        return commissionCheckId;
    }

    public void setCommissionCheckId(Long commissionCheckId) {
        this.commissionCheckId = commissionCheckId;
    }

    public Integer getIsActive() {
        return isActive;
    }

    public void setIsActive(Integer isActive) {
        this.isActive = isActive;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Long getCreatedBy() {
        return createdBy;
    }

    public void setCreatedBy(Long createdBy) {
        this.createdBy = createdBy;
    }

    public Date getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Long getUpdatedBy() {
        return updatedBy;
    }

    public void setUpdatedBy(Long updatedBy) {
        this.updatedBy = updatedBy;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        AgPoOrderCommission other = (AgPoOrderCommission) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getCommissionNo() == null ? other.getCommissionNo() == null : this.getCommissionNo().equals(other.getCommissionNo()))
            && (this.getCommissionType() == null ? other.getCommissionType() == null : this.getCommissionType().equals(other.getCommissionType()))
            && (this.getCustomerId() == null ? other.getCustomerId() == null : this.getCustomerId().equals(other.getCustomerId()))
            && (this.getPractitionerId() == null ? other.getPractitionerId() == null : this.getPractitionerId().equals(other.getPractitionerId()))
            && (this.getOrderId() == null ? other.getOrderId() == null : this.getOrderId().equals(other.getOrderId()))
            && (this.getPolicyNo() == null ? other.getPolicyNo() == null : this.getPolicyNo().equals(other.getPolicyNo()))
            && (this.getProductName() == null ? other.getProductName() == null : this.getProductName().equals(other.getProductName()))
            && (this.getCommissionYear() == null ? other.getCommissionYear() == null : this.getCommissionYear().equals(other.getCommissionYear()))
            && (this.getPaymentTerm() == null ? other.getPaymentTerm() == null : this.getPaymentTerm().equals(other.getPaymentTerm()))
            && (this.getPremium() == null ? other.getPremium() == null : this.getPremium().equals(other.getPremium()))
            && (this.getCommissionCategory() == null ? other.getCommissionCategory() == null : this.getCommissionCategory().equals(other.getCommissionCategory()))
            && (this.getOldrate() == null ? other.getOldrate() == null : this.getOldrate().equals(other.getOldrate()))
            && (this.getRate() == null ? other.getRate() == null : this.getRate().equals(other.getRate()))
            && (this.getAmount() == null ? other.getAmount() == null : this.getAmount().equals(other.getAmount()))
            && (this.getCommissionStatus() == null ? other.getCommissionStatus() == null : this.getCommissionStatus().equals(other.getCommissionStatus()))
            && (this.getCommissionTime() == null ? other.getCommissionTime() == null : this.getCommissionTime().equals(other.getCommissionTime()))
            && (this.getCommissionPeriod() == null ? other.getCommissionPeriod() == null : this.getCommissionPeriod().equals(other.getCommissionPeriod()))
            && (this.getCommissionCheckId() == null ? other.getCommissionCheckId() == null : this.getCommissionCheckId().equals(other.getCommissionCheckId()))
            && (this.getIsActive() == null ? other.getIsActive() == null : this.getIsActive().equals(other.getIsActive()))
            && (this.getRemark() == null ? other.getRemark() == null : this.getRemark().equals(other.getRemark()))
            && (this.getCreatedAt() == null ? other.getCreatedAt() == null : this.getCreatedAt().equals(other.getCreatedAt()))
            && (this.getCreatedBy() == null ? other.getCreatedBy() == null : this.getCreatedBy().equals(other.getCreatedBy()))
            && (this.getUpdatedAt() == null ? other.getUpdatedAt() == null : this.getUpdatedAt().equals(other.getUpdatedAt()))
            && (this.getUpdatedBy() == null ? other.getUpdatedBy() == null : this.getUpdatedBy().equals(other.getUpdatedBy()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getCommissionNo() == null) ? 0 : getCommissionNo().hashCode());
        result = prime * result + ((getCommissionType() == null) ? 0 : getCommissionType().hashCode());
        result = prime * result + ((getCustomerId() == null) ? 0 : getCustomerId().hashCode());
        result = prime * result + ((getPractitionerId() == null) ? 0 : getPractitionerId().hashCode());
        result = prime * result + ((getOrderId() == null) ? 0 : getOrderId().hashCode());
        result = prime * result + ((getPolicyNo() == null) ? 0 : getPolicyNo().hashCode());
        result = prime * result + ((getProductName() == null) ? 0 : getProductName().hashCode());
        result = prime * result + ((getCommissionYear() == null) ? 0 : getCommissionYear().hashCode());
        result = prime * result + ((getPaymentTerm() == null) ? 0 : getPaymentTerm().hashCode());
        result = prime * result + ((getPremium() == null) ? 0 : getPremium().hashCode());
        result = prime * result + ((getCommissionCategory() == null) ? 0 : getCommissionCategory().hashCode());
        result = prime * result + ((getOldrate() == null) ? 0 : getOldrate().hashCode());
        result = prime * result + ((getRate() == null) ? 0 : getRate().hashCode());
        result = prime * result + ((getAmount() == null) ? 0 : getAmount().hashCode());
        result = prime * result + ((getCommissionStatus() == null) ? 0 : getCommissionStatus().hashCode());
        result = prime * result + ((getCommissionTime() == null) ? 0 : getCommissionTime().hashCode());
        result = prime * result + ((getCommissionPeriod() == null) ? 0 : getCommissionPeriod().hashCode());
        result = prime * result + ((getCommissionCheckId() == null) ? 0 : getCommissionCheckId().hashCode());
        result = prime * result + ((getIsActive() == null) ? 0 : getIsActive().hashCode());
        result = prime * result + ((getRemark() == null) ? 0 : getRemark().hashCode());
        result = prime * result + ((getCreatedAt() == null) ? 0 : getCreatedAt().hashCode());
        result = prime * result + ((getCreatedBy() == null) ? 0 : getCreatedBy().hashCode());
        result = prime * result + ((getUpdatedAt() == null) ? 0 : getUpdatedAt().hashCode());
        result = prime * result + ((getUpdatedBy() == null) ? 0 : getUpdatedBy().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", id=").append(id);
        sb.append(", commissionNo=").append(commissionNo);
        sb.append(", commissionType=").append(commissionType);
        sb.append(", customerId=").append(customerId);
        sb.append(", practitionerId=").append(practitionerId);
        sb.append(", orderId=").append(orderId);
        sb.append(", policyNo=").append(policyNo);
        sb.append(", productName=").append(productName);
        sb.append(", commissionYear=").append(commissionYear);
        sb.append(", paymentTerm=").append(paymentTerm);
        sb.append(", premium=").append(premium);
        sb.append(", commissionCategory=").append(commissionCategory);
        sb.append(", oldrate=").append(oldrate);
        sb.append(", rate=").append(rate);
        sb.append(", amount=").append(amount);
        sb.append(", commissionStatus=").append(commissionStatus);
        sb.append(", commissionTime=").append(commissionTime);
        sb.append(", commissionPeriod=").append(commissionPeriod);
        sb.append(", commissionCheckId=").append(commissionCheckId);
        sb.append(", isActive=").append(isActive);
        sb.append(", remark=").append(remark);
        sb.append(", createdAt=").append(createdAt);
        sb.append(", createdBy=").append(createdBy);
        sb.append(", updatedAt=").append(updatedAt);
        sb.append(", updatedBy=").append(updatedBy);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}