package com.yd.api.agms.service.impl;
import com.google.common.collect.Lists;

import com.yd.api.agms.service.AgmsSharingService;
import com.yd.api.agms.vo.sharing.ControllerResponseVO;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.util.Arrays;

/**
 * @author xxy
 */
@Service("agmsSharingService")
public class AgmsSharingServiceImpl implements AgmsSharingService {
    @Override
    public ControllerResponseVO controller(String action, MultipartFile upfile) {
        ControllerResponseVO responseVO = new ControllerResponseVO();
        if ("uploadimage".equals(action)) {
            responseVO.setImageActionName("uploadimage");
            responseVO.setImageFieldName("upfile");
            responseVO.setImageMaxSize(2048000);
            String[] imageAllowFiles = new String[]{".png", ".jpg", ".jpeg", ".gif", ".bmp"};
            responseVO.setImageAllowFiles(Arrays.asList(imageAllowFiles.clone()));
            responseVO.setImageCompressEnable(true);
            responseVO.setImageCompressBorder(1600);
            responseVO.setImageInsertAlign("none");
            responseVO.setImageUrlPrefix("");
            responseVO.setImagePathFormat("/sharing/image/{time}{rand:6}");
            responseVO.setScrawlActionName("uploadscrawl");
            responseVO.setScrawlFieldName("upfile");
            responseVO.setScrawlPathFormat("/sharing/image/{time}{rand:6}");
            responseVO.setScrawlMaxSize(2048000);
            responseVO.setScrawlUrlPrefix("");
            responseVO.setScrawlInsertAlign("none");
            responseVO.setSnapscreenActionName("uploadimage");
            responseVO.setSnapscreenPathFormat("/sharing/image/{time}{rand:6}");
            responseVO.setSnapscreenUrlPrefix("");
            responseVO.setSnapscreenInsertAlign("none");
            String[] catcherLocalDomain = new String[]{"127.0.0.1", "localhost", "img.baidu.com"};
            responseVO.setCatcherLocalDomain(Arrays.asList(catcherLocalDomain.clone()));
            responseVO.setCatcherActionName("catchimage");
            responseVO.setCatcherFieldName("source");
            responseVO.setCatcherPathFormat("/sharing/image/{time}{rand:6}");
            responseVO.setCatcherUrlPrefix("");
            responseVO.setCatcherMaxSize(2048000);
            String[] catcherAllowFiles = new String[]{".png", ".jpg", ".jpeg", ".gif", ".bmp"};
            responseVO.setCatcherAllowFiles(Arrays.asList(catcherAllowFiles.clone()));
            responseVO.setVideoActionName("uploadvideo");
            responseVO.setVideoFieldName("upfile");
            responseVO.setVideoPathFormat("/sharing/video/{time}{rand:6}");
            responseVO.setVideoUrlPrefix("");
            responseVO.setVideoMaxSize(102400000);
            String[] videoAllowFiles = new String[]{".flv", ".swf", ".mkv", ".avi", ".rm", ".rmvb", ".mpeg", ".mpg",
                    ".ogg", ".ogv", ".mov", ".wmv", ".mp4", ".webm", ".mp3", ".wav", ".mid"};
            responseVO.setVideoAllowFiles(Arrays.asList(videoAllowFiles.clone()));
            responseVO.setFileActionName("uploadfile");
            responseVO.setFileFieldName("upfile");
            responseVO.setFilePathFormat("/sharing/file/{time}{rand:6}");
            responseVO.setFileUrlPrefix("");
            responseVO.setFileMaxSize(51200000);
            String[] fileAllowFiles = new String[]{".png", ".jpg", ".jpeg", ".gif", ".bmp",
                    ".flv", ".swf", ".mkv", ".avi", ".rm", ".rmvb", ".mpeg", ".mpg",
                    ".ogg", ".ogv", ".mov", ".wmv", ".mp4", ".webm", ".mp3", ".wav", ".mid",
                    ".rar", ".zip", ".tar", ".gz", ".7z", ".bz2", ".cab", ".iso",
                    ".doc", ".docx", ".xls", ".xlsx", ".ppt", ".pptx", ".pdf", ".txt", ".md", ".xml"};
            responseVO.setFileAllowFiles(Arrays.asList(fileAllowFiles.clone()));
            responseVO.setImageManagerActionName("listimage");
            responseVO.setImageManagerListPath("/sharing/image/");
            responseVO.setImageManagerListSize(20);
            responseVO.setImageManagerUrlPrefix("");
            responseVO.setImageManagerInsertAlign("none");
            String[] imageManagerAllowFiles = new String[]{".png", ".jpg", ".jpeg", ".gif", ".bmp"};
            responseVO.setImageManagerAllowFiles(Arrays.asList(imageManagerAllowFiles.clone()));
            responseVO.setFileManagerActionName("listfile");
            responseVO.setFileManagerListPath("/sharing/file/");
            responseVO.setFileManagerUrlPrefix("");
            responseVO.setFileManagerListSize(20);
            String[] fileManagerAllowFiles = new String[]{".png", ".jpg", ".jpeg", ".gif", ".bmp",
                    ".flv", ".swf", ".mkv", ".avi", ".rm", ".rmvb", ".mpeg", ".mpg",
                    ".ogg", ".ogv", ".mov", ".wmv", ".mp4", ".webm", ".mp3", ".wav", ".mid",
                    ".rar", ".zip", ".tar", ".gz", ".7z", ".bz2", ".cab", ".iso",
                    ".doc", ".docx", ".xls", ".xlsx", ".ppt", ".pptx", ".pdf", ".txt", ".md", ".xml"};
            responseVO.setFileManagerAllowFiles(Arrays.asList(fileManagerAllowFiles.clone()));
        } else if ("config".equals(action)){
            responseVO.setState("");
            responseVO.setUrl("");
            responseVO.setTitle("");
            responseVO.setOriginal("");
            responseVO.setType("");
            responseVO.setSize(0L);
        }
        return responseVO;
    }
}
