package com.yd.api.practitioner.service;

import com.yd.api.practitioner.vo.login.PractitionerLoginRequestVO;
import com.yd.api.practitioner.vo.login.PractitionerLoginResponseVO;
import com.yd.api.practitioner.vo.rank.PractitionerRankRequestVO;
import com.yd.api.practitioner.vo.rank.PractitionerRankResponseVO;
import com.yd.api.practitioner.vo.setting.SettingQueryRequestVO;
import com.yd.api.practitioner.vo.setting.SettingQueryResponseVO;
import org.springframework.stereotype.Service;

@Service("practitionerService")
public interface PractitionerService {

    /**
     * 经纪人登录接口
     * @param requestVO 请求信息
     * @return PractitionerLoginResponseVO
     */
    PractitionerLoginResponseVO practitionerLogin(PractitionerLoginRequestVO requestVO);

    /**
     * 经纪人排行榜查询
     * @param requestVO 请求信息
     * @return PractitionerRankResponseVO
     */
    PractitionerRankResponseVO practitionerRank(PractitionerRankRequestVO requestVO);

    /**
     * 经纪人设置查询
     * @param requestVO
     * @return
     */
    SettingQueryResponseVO settingQuery(SettingQueryRequestVO requestVO);
}
