package com.yd.api.customer;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.yd.api.customer.service.CustomerService;
import com.yd.api.customer.vo.CustomerFortuneRequestVO;
import com.yd.api.customer.vo.CustomerFortuneResponseVO;
import com.yd.api.customer.vo.CustomerQueryRequestVO;
import com.yd.api.customer.vo.CustomerQueryResponseVO;
import com.yd.api.customer.vo.CustomerVO;
import com.yd.api.market.vo.announcement.AnnouncementQueryResponseVO;
import com.yd.api.result.JsonResult;

@Controller
@RestController
public class CustomerController {
	
	@Autowired
	private CustomerService customerService;
	
	@RequestMapping("/listAllCustomer")
	public Object listAllCustomer(){
        JsonResult result = new JsonResult();

        List<CustomerVO> list = customerService.listAllCustomer();
       
        result.setData(list);

        return result;
	}	
	/**
	 * 分页查询案例
	 * @param customerQueryRequestVO
	 * @return
	 */
	@RequestMapping("/findByPage")
	public Object findByPage(@RequestBody CustomerQueryRequestVO customerQueryRequestVO){
		JsonResult result = new JsonResult();
		CustomerQueryResponseVO erpOrderQueryResponseVO = customerService.findByPage(customerQueryRequestVO);
		result.addResult(erpOrderQueryResponseVO);
		result.setData(erpOrderQueryResponseVO);
		return result;
	}
	/**
	 * 分页查询案例
	 * @param customerQueryRequestVO
	 * @return
	 */
	@RequestMapping("/selectByCustomerId")
	public Object selectByCustomerId(@RequestBody CustomerFortuneRequestVO customerQueryRequestVO){
		JsonResult result = new JsonResult();
		CustomerFortuneResponseVO erpOrderQueryResponseVO = customerService.selectByCustomerId(customerQueryRequestVO);
		result.addResult(erpOrderQueryResponseVO);
		result.setData(erpOrderQueryResponseVO);
		return result;
	}	
}