package com.yd.rmi.n22.policy.pojo.policydetail;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class PolicyDetailQueryResponseBody {
    private Long policyId;//保单序列号, 内部使用.如果是第三方输入数据, 该字段无需填写.
    private Long productId;//产品序列号, 内部使用.如果是第三方输入数据, 该字段无需填写.
    private String vendorCode;//产品提供商代码, 必须提供
    private String vendorName;//产品供应商名称（保司名称）
    private String productCode;//产品代码, 必须提供
    private String productName;//产品名称
    private String productVersion;//产品版本, 必须提供.
    private Date effectiveDate;//保单生效日2017/10/18 00:00:00
    private Date expiryDate;//保单失效日2017/10/18 00:00:00
    private Date quotationNo;//订单号, 内部使用.
    private String policyNo;//保单号.
    private Date issueDate;//出单日
    private Date quoteDate;//首次报价日
    private String thirdQuoteNo;//第三方(例如：保司)报价单号
    private String thirdOrderNo;//第三方(例如：保司)订单号
    private String ePolicyDownloadUrl;//电子保单下载地址
    private Double premium;//保费.
    private Boolean renewal;//是否是续保 Y/N
    private String lastPolicyNo;//上一张保单的保单号, 只有在续保件的时候才会有值, 并且必须有值.
    private String policyStatus;//保单状态.
    private String policyFee;//保单层级费用. 参考 保单费用 说明
    private CommissionsN22 commissions;//保单级佣金. 参考 保单佣金 说明
    private ExtensionN22 extensionData;//扩展栏位, 存放一切未显式定义的内容. 参考保单扩展栏位 说明
    private List<InsuredDetailN22> insureds;//标的. 例如寿险的被保人, 车险的车辆等
    private PolicyHolderN22 policyHolder;//投保人. 参考 投保人 说明
    private AgentN22 agent;//代理人. 参考 代理人 说明
    private String thirdPartyAgentId;//第三方代理人号,对于第三方的只做保存，用于报表显示.
    private String thirdPartyAgentName;//第三方代理人姓名,对于第三方的只做保存，用于报表显示.
    @JsonProperty("order_player")
    private String orderPlayer;//打单员
    @JsonProperty("beto_rolegroup")
    private String betoRoleGroup;//机构code
    @JsonProperty("beto_rolegroupdesc")
    private String betoRoleGroupDesc;//机构名称
    private List<BuryingPointN22> buryingPointList;//互联网产品埋点列表，用于记录在投保过程中各个阶段的时间点
    @JsonProperty("BuryingVideo")
    private String buryingVideo;//埋点视频编号
    @JsonProperty("installment_premium")
    private List<InstallmentPremiumN22> installmentPremium;//保单分期列表
    private String sourceCode;//保单来源，如XXAPP下单，在保单同步时填写后，会在这里体现
    private String butler;//管家
}
