package com.yd.dal.entity.customer;

import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
    * 财务红包小助手真实付给客户提现记录
    */
@Data
public class AclCustomerFortunePay {
    /**
    * serial id
    */
    private Long id;

    /**
    * FK ag_acl_customer_fortune_withdraw.id
    */
    private Long withdrawId;

    /**
    * 提现金额
    */
    private BigDecimal withdrawAmount;

    /**
    * FK ag_acl_customer.id
    */
    private Long customerId;

    private String customerName;

    /**
    * 活动id, FK ag_md_mk_campaign.id
    */
    private Long campaignId;

    /**
    * 活动名称
    */
    private String campaignName;

    /**
    * 活动酬金额
    */
    private BigDecimal campaingReward;

    /**
    * 收款者
    */
    private String payTo;

    private String payToMobile;

    /**
    * 收款者微信账号
    */
    private String payToWechat;

    /**
    * 收款者证件类型 FK ag_md_id_type, 1=身份证 2=护照 4=台胞证 5=香港身份证
    */
    private Long payToIdTypeId;

    /**
    * 收款者证件号码
    */
    private String payToIdNo;

    /**
    * 收款者生日
    */
    private Date payToBirthday;

    /**
    * 收款者性别 1=Male, 2=Female
    */
    private Integer payToGender;

    /**
    * 付款日
    */
    private Date payDate;

    /**
    * 付款金额
    */
    private BigDecimal payAmount;

    /**
    * 代缴税额
    */
    private BigDecimal taxAmount;

    /**
    * 付款执行者
    */
    private String paidBy;

    /**
    * 1. Wechat red envelope 3. Bank
    */
    private Integer paidMethod;

    /**
    * 0. 待付 1已付
    */
    private Integer payStatus;

    /**
    * 注释或补充
    */
    private String remark;

    private Date createdAt;

    private Long createdBy;

    private Date updatedAt;

    /**
    * 变更者 id
    */
    private Long updatedBy;
}