package com.yd.dal.service.meta.impl;

import com.google.common.base.Strings;
import com.yd.dal.entity.meta.MdCode;
import com.yd.dal.mapper.meta.MdCodeMapper;
import com.yd.dal.service.meta.MdCodeDALService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
@Service("mdCodeDALService")
public class MdCodeDALServiceImpl implements MdCodeDALService {
    @Resource
    private MdCodeMapper mdCodeMapper;

    @Override
    public List<MdCode> findByCodeType(String codeType) {
        List<MdCode> codeList = new ArrayList<>();
        if(!Strings.isNullOrEmpty(codeType)){
            codeList = mdCodeMapper.findByCodeType(codeType);
        }
        return codeList;
    }

    @Override
    public String findCodeByType(String codeType) {
        if(!Strings.isNullOrEmpty(codeType)){
            return mdCodeMapper.findCodeByType(codeType);
        }
        return null;
    }

    @Override
    public List<MdCode> findByMdCode(MdCode mdCode) {
        return mdCodeMapper.findByMdCode(mdCode);
    }
}
