package com.yd.api.agms.service.impl;

import com.yd.api.agms.service.AgmsInsurerService;
import com.yd.api.agms.vo.insurer.SealUploadResponseVO;
import com.yd.api.result.CommonResult;
import com.yd.dal.entity.customer.AclInsurerBranch;
import com.yd.dal.entity.customer.AclInsurerBranchDept;
import com.yd.dal.service.customer.AclInsurerBranchDALService;
import com.yd.dal.service.customer.AclInsurerBranchDeptDALService;
import com.yd.util.CommonUtil;
import com.yd.util.config.ZHBErrorConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Date;

/**
 * @author xxy
 */
@Service("agmsInsurerService")
@PropertySource({"classpath:pdfconfiguration.properties"})
public class AgmsInsurerServiceImpl implements AgmsInsurerService {

    @Value("${pdf.signImage}")
    private String signImage;

    @Autowired
    private AclInsurerBranchDALService aclInsurerBranchDALService;

    @Autowired
    private AclInsurerBranchDeptDALService aclInsurerBranchDeptDALService;

    @Override
    public SealUploadResponseVO sealUpload(MultipartFile sealFile, Long loginId, Long insurerBranchId, Long insurerBranchDeptId) {
        SealUploadResponseVO responseVO = new SealUploadResponseVO();
        boolean success = true;
        String message = ZHBErrorConfig.getErrorInfo("800000");
        try {
            byte[] bytes = sealFile.getBytes();
            InputStream in = new ByteArrayInputStream(bytes);
            InetAddress address = InetAddress.getLocalHost();
            File outFile = new File(signImage + sealFile.getName());
            System.out.println("http://" + address + signImage);
//            File outFile = new File("D:\\"+sealFile.getOriginalFilename());
            FileOutputStream out = new FileOutputStream(outFile);
            byte[] bts = new byte[1024];
            int len = 0;
            while ((len = in.read(bts)) != -1) {
                out.write(bts, 0, len);
            }
            if (!CommonUtil.isNullOrZero(insurerBranchId)) {
                AclInsurerBranch branch = new AclInsurerBranch();
                branch.setId(insurerBranchId);
                branch.setElectronicTaxSeal("http://" + address + signImage);
                branch.setUpdatedAt(new Date());
                branch.setUpdatedBy(loginId);
                aclInsurerBranchDALService.update(branch);
            }
            if (!CommonUtil.isNullOrZero(insurerBranchDeptId)) {
                AclInsurerBranchDept dept = new AclInsurerBranchDept();
                dept.setId(insurerBranchDeptId);
                dept.setElectronicTaxSeal("http://" + address + signImage);
                dept.setUpdatedAt(new Date());
                dept.setUpdatedBy(loginId);
                aclInsurerBranchDeptDALService.update(dept);
            }
            responseVO.setFileUrl("http://" + address + signImage);
        } catch (Exception e) {
            success = false;
            message = ZHBErrorConfig.getErrorInfo("830025");
            e.printStackTrace();
        }

        responseVO.setCommonResult(new CommonResult(success, message));
        return responseVO;
    }
}
