package com.yd.api.practitioner.vo;

import java.text.SimpleDateFormat;
        import java.util.Date;
        import java.util.HashMap;
        import java.util.Map;
        import com.yd.libs.pdf.*;

public class PDFHiringTest {
    /**
     * 填充数据源
     * 其中data存放的key值与pdf模板中的文本域值相对应
     */
    public static Map<String, String> initData() {
        String secondSignature = "张亮";
        String secondPartyIDNo = "330127199611154184";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String secondSignatureDate = format.format(new Date());

        Map<String, String> data = new HashMap<String, String>();
        //1页
        data.put("contactNo", "C-SH-0001");
        data.put("practitionerNo", "YDSH00127");
        data.put("subsystem", "抱一");
        data.put("practitioner", secondSignature);
        data.put("idNo", secondPartyIDNo);
        data.put("residentAddress", "上海市浦东新区张杨路560号中融恒瑞国际西楼1706室");
        data.put("mobileNo", "13661741633");
        //7页
        data.put("firstParty", "上海银盾保险经纪有限公司");
        data.put("firstPartyResponer", "上海银盾保险经纪有限公司");
        data.put("firstPartyAddress", "上海市浦东新区张杨路560号中融恒瑞国际西楼1706室");

        data.put("secondParty", secondSignature);
        data.put("secondPartyIDNo", secondPartyIDNo);
        data.put("secondPartyAddress", "上海市浦东新区张杨路560号中融恒瑞国际西楼1706室");
        data.put("secondMobileNo", "1366668888");
        data.put("secondSubsystemOwner", "陈欢欢");
        data.put("secondSubsystemSignature", "陈欢欢");
        data.put("secondSubsystemIDNo", "330127199611156403");
        data.put("secondSubsystemAddress", "上海市浦东新区张杨路560号中融恒瑞国际西楼1706室");
        data.put("secondSubsystemMobileNo", "1366668888");
        data.put("secondMentor", "陈欢欢");
        data.put("secondMentorIDNo", "330127199611158003");
        data.put("secondMentorAddress", "上海市浦东新区张杨路560号中融恒瑞国际西楼1706室");
        data.put("secondMentorMobileNo", "1366668888");
        data.put("contactYear", "2120");
        data.put("contactMonth", "12");
        data.put("contactDay", "16");
        //8页
        data.put("secondParty801", secondSignature);
        data.put("secondBirthYear801", "1989");
        data.put("secondBirthMonth801", "10");
        data.put("secondBirthDay801", "09");
        data.put("secondPartyIDNo801", secondPartyIDNo);
        data.put("secondPartyPermanentResidenceAddress", "上海市浦东新区张杨路560号中融恒瑞国际西楼1706室");
        data.put("secondPartyAddress801", "上海市浦东新区张杨路560号中融恒瑞国际西楼1706室");
        data.put("secondMobileNo801", "1366668888");
        data.put("secondPractitionerRegNo", "26961531000080062020000314");
        data.put("secondEmail", "2120@163.com");
        data.put("secondWorkingExperience1", "嫦娥5号登月");
        data.put("secondWorkingPosition1", "项目总工");
        data.put("secondWorkingPeriod1", "2016.12~至今");
        data.put("secondWorkingExperience2", "嫦娥4号登月");
        data.put("secondWorkingPosition2", "姿态调整工程师");
        data.put("secondWorkingPeriod2", "2014.11~2016.10");
        data.put("secondWorkingExperience3", "嫦娥3号登月");
        data.put("secondWorkingPosition3", "动力工程执掌");
        data.put("secondWorkingPeriod3", "2012.03~2014.10");
        data.put("secondWorkingExperience4", "嫦娥2号登月");
        data.put("secondWorkingPosition4", "固态燃料冷凌技师");
        data.put("secondWorkingPeriod4", "2010.07~2012.01");
        data.put("secondBankAccount", secondSignature);
        data.put("secondBankAccountOpening", "上海市工商银行齐齐哈尔路支行");
        data.put("secondBankAccountID", "6222001001234567890");
        data.put("secondMentor802", "陈欢欢");
        data.put("secondIntroducer", "陈欢欢");
        data.put("secondMentorIDNo801", "330127199611151346");
        data.put("secondIntroducerIDNo", "330127199611156403");

        data.put("secondEffectiveYear", "2120");
        data.put("secondEffectiveMonth", "12");
        data.put("secondEffectiveDay", "30");
        data.put("secondParty802", secondSignature);
        data.put("secondMentor801", "陈欢欢");
        data.put("secondSubsystem", "抱一");
        data.put("secondSubsystemNo", "HUGONE");
        data.put("secondSubsystemManager", "陈欢欢");
        data.put("secondSubsystemMaster", "陈欢欢");
        data.put("secondBranchManager", "王子帷");
        data.put("secondBranchMaster", "王子帷");
        data.put("secondCenterHr", "EVEN");
        data.put("secondCenterCEO", "SHARON");

        //9页

        //10页
        data.put("secondSignatureDate1001", secondSignatureDate);
        //12页
        data.put("secondParty1201", secondSignature);
        data.put("secondSignatureDate1201", secondSignatureDate);
        //14页
        data.put("secondParty1401", secondSignature);
        data.put("secondSignatureDate1401", secondSignatureDate);
        //16页
        data.put("secondParty1601", secondSignature);
        data.put("secondPartyIDNo1601", secondPartyIDNo);
        data.put("secondSignatureDate1601", secondSignatureDate);

        return data;
    }

    public static Map<String, String> initImage() {
        Map<String, String> images = new HashMap<String, String>();
        //公司印章，需配置
        String yindunESignature = "D:\\pcs12\\上海银盾保险经纪有限公司.png";
        images.put("yindunESignature1001", "D:\\pcs12\\上海银盾保险经纪有限公司.png");
        images.put("yindunESignature1201", "D:\\pcs12\\上海银盾保险经纪有限公司.png");
        images.put("yindunESignature1401", "D:\\pcs12\\上海银盾保险经纪有限公司.png");

        //五张图是动态的，根据DB里面记录的OSS Path，先从阿里云下载到本地作为临时文件，处理模板需要本地文件
        //经纪人个人照片
        String secondPersonerPicture = "D:\\pcs12\\secondPersonerPicture.png";
        images.put("secondPersonerPicture", secondPersonerPicture);
        //经纪人个人手写签名图
        String secondSignature = "D:\\pcs12\\signature.png";
        images.put("secondSignature1001", secondSignature);
        images.put("secondSignature1201", secondSignature);
        images.put("secondSignature1401", secondSignature);
        images.put("secondSignature1601", secondSignature);
        //经纪人个人身份证正面图
        String secondIDFrontPageImage = "D:\\pcs12\\IDFront.jpg";
        images.put("secondIDFrontPageImage", secondIDFrontPageImage);
        //经纪人个人身份证背面图
        String secondIDBackPageImage = "D:\\pcs12\\IDback.jpg";
        images.put("secondIDBackPageImage", secondIDBackPageImage);
        //经纪人个人银行卡正面图
        String secondBankCardImage = "D:\\pcs12\\bank.jpg";
        images.put("secondBankCardImage", secondBankCardImage);

        //选中或未选中2张图，需配置
        //PDF模板文件中4种身份证件类型
        images.put("secondIDType1", "D:\\pcs12\\checked.png");
        images.put("secondIDType2", "D:\\pcs12\\uncheck.png");
        images.put("secondIDType3", "D:\\pcs12\\uncheck.png");
        images.put("secondIDType4", "D:\\pcs12\\uncheck.png");
        //个人申明中的6个选项，从左到右，从上到下
        images.put("secondPersonalStatement1", "D:\\pcs12\\checked.png");
        images.put("secondPersonalStatement2", "D:\\pcs12\\uncheck.png");
        images.put("secondPersonalStatement3", "D:\\pcs12\\uncheck.png");
        images.put("secondPersonalStatement4", "D:\\pcs12\\uncheck.png");
        images.put("secondPersonalStatement5", "D:\\pcs12\\uncheck.png");
        images.put("secondPersonalStatement5", "D:\\pcs12\\checked.png");
        //个人签约职称中的6个选项，从左到右，从上到下
        images.put("secondPosition1", "D:\\pcs12\\checked.png");
        images.put("secondPosition2", "D:\\pcs12\\uncheck.png");
        images.put("secondPosition3", "D:\\pcs12\\uncheck.png");
        images.put("secondPosition4", "D:\\pcs12\\uncheck.png");
        images.put("secondPosition5", "D:\\pcs12\\uncheck.png");
        images.put("secondPosition6", "D:\\pcs12\\uncheck.png");

        return images;
    }

    public static void main(String[] args) throws Exception {
        //PDF模板文件，需配置
        String templatePDF = "D:\\pcs12\\templatePractitionerContract.pdf";
        //PDF模板输出结果文件
        String templateResultPDF = "D:\\pcs12\\resultData.pdf";
        //初始化模板数据
        Map<String, String> dt = initData();
        Map<String, String> img = initImage();
        //按模板填充数据生成结果PDF
        PDFTemplate.generatePDF(templatePDF, templateResultPDF, dt, img);

        //准备加盖电子印章的源文件
        String signSourcePDF = templateResultPDF;

        //电子印章文件，需配置
        String signImage = "D:\\pcs12\\上海银盾保险经纪有限公司.png";
        //加盖电子印章结果文件
        String signResultPDF = "D:\\pcs12\\signedYD.pdf";

        String password = "UC645YlB";
        //CA证书文件，需配置
        String keyStorePath = "D:\\pcs12\\4929078_m.zuihuibi.cn.pfx";
        float x = 450;
        float y = 150;
        PDFSign.sign(signResultPDF, password, keyStorePath, signSourcePDF, signImage, x, y);
    }
}
