package com.yd.dal.entity.customer;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * ag_acl_user
 * @author 
 */
@Data
public class AclUser implements Serializable {
    /**
     * serial id
     */
    private Long id;

    /**
     * 1= Staff  2.Customer  3.Partner
     */
    private Integer userRole;

    /**
     * 员工编号
     */
    private String employeeNo;

    /**
     * 1= 安吉保 2=银盾
     */
    private Integer company;

    /**
     * FK ag_system_dept.id
     */
    private Long deptId;

    /**
     * FK ag_system_role.id
     */
    private Long roleId;

    /**
     * login ID
     */
    private String login;

    /**
     * 88888888
     */
    private String password;

    /**
     * user name
     */
    private String name;

    /**
     * user nickname
     */
    private String nickname;

    private String mobileNo;

    private String idNo;

    /**
     * 最后登入时间
     */
    private Date lastLoginTime;

    /**
     * 最后登出时间
     */
    private Date logoutTime;

    /**
     * 1=PC 2=Mobile 3=Pad
     */
    private Integer loginSource;

    /**
     * 0=No, 1=Yes
     */
    private Integer isActive;

    /**
     * 员工email
     */
    private String email;

    /**
     * 创建日期
     */
    private Date createdAt;

    /**
     * creator
     */
    private Long createdBy;

    /**
     * 0000-00-00 00:00:00
     */
    private Date updatedAt;

    /**
     * updator, FK ag_acl_user.id
     */
    private Long updatedBy;

    private static final long serialVersionUID = 1L;
}