package com.yd.dal.service.customer;

import com.yd.api.practitioner.vo.login.PractitionerLoginRequestVO;
import com.yd.dal.entity.customer.AclCustomerLog;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("aclCustomerLogDALService")
public interface AclCustomerLogDALService {

    /**
     * 根据customerId查询指定用户的日志
     * @param customerId
     * @return
     */
    List<AclCustomerLog> findLogInfoByCustomerId(Long customerId);

    /**
     * 保存用户日志
     * @param customerId 用户id
     * @param plateFlag 1-在线平台 2-经纪
     */
    Long saveCustomerLog(Long customerId, int plateFlag, PractitionerLoginRequestVO requestVO);
    /**
     * 根据手机号查询最大的日志id
     * @date:   2021/11/8
     */
    Long findLogInfoByMobileNo(String mobileNo);
}
