package com.yd.api.practitioner.service.impl;

import com.yd.api.practitioner.service.PractitionerHiringService;
import com.yd.api.practitioner.vo.hiring.*;
import com.yd.api.result.CommonResult;
import com.yd.dal.entity.customer.AclPractitionerHiringBasicInfo;
import com.yd.dal.entity.customer.AclPractitionerHiringMembership;
import com.yd.dal.entity.customer.AclPractitionerHiringWorkingExperience;
import com.yd.dal.mapper.customer.AclPractitionerHiringBasicInfoMapper;
import com.yd.dal.mapper.customer.AclPractitionerHiringMembershipMapper;
import com.yd.dal.mapper.customer.AclPractitionerHiringWorkingExperienceMapper;
import com.yd.rmi.tencent.wechat.service.WechatService;
import com.yd.rmi.tencent.wechatinterf.pojo.ticket.TicketRequest;
import com.yd.rmi.tencent.wechatinterf.pojo.token.TokenRequest;
import com.yd.util.CommonUtil;
import com.yd.util.HttpUtil;
import com.yd.util.config.ZHBErrorConfig;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.imageio.ImageIO;
import java.awt.*;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;


@Service
public class PractitionerHiringServiceImpl implements PractitionerHiringService {

    @Autowired
    private WechatService wechatService;
    @Autowired
    private AclPractitionerHiringMembershipMapper membershipMapper;
    @Autowired
    private AclPractitionerHiringBasicInfoMapper basicInfoMapper;
    @Autowired
    private AclPractitionerHiringWorkingExperienceMapper workingExperienceMapper;

    @Override
    public SaveMembershipResponseVO saveMembership(SaveMembershipRequestVO requestVO) {
        SaveMembershipResponseVO resp = new SaveMembershipResponseVO();
        try {
            // 先保存ag_acl_practitioner_hiring_basic_info，获取hiringBasicInfoId
            AclPractitionerHiringBasicInfo basicInfo = new AclPractitionerHiringBasicInfo();
            basicInfo.setName(requestVO.getName());
            basicInfo.setPractitionerPotentialId(requestVO.getPractitionerPotentialId());
            basicInfoMapper.insertSelective(basicInfo);

            // 数据库实体
            AclPractitionerHiringMembership membership = new AclPractitionerHiringMembership();
            BeanUtils.copyProperties(requestVO, membership);
            membership.setIsActive(1);

            Date curDate = new Date();
            membership.setCreatedAt(curDate);
            membership.setUpdatedAt(curDate);

            Long loginId = requestVO.getLoginId();
            membership.setCreatedBy(loginId);
            membership.setUpdatedBy(loginId);

            membershipMapper.insertSelective(membership);

            resp.setHiringBasicInfoId(basicInfo.getId());
            resp.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        } catch (Exception e) {
            e.printStackTrace();
            resp.setCommonResult(new CommonResult(false, e.getMessage()));
        }
        return resp;
    }

    @Override
    public SaveBasicInfoResponseVO saveBasicInfo(SaveBasicInfoRequestVO requestVO) {
        SaveBasicInfoResponseVO resp = new SaveBasicInfoResponseVO();
        try {
            // 数据库实体
            AclPractitionerHiringBasicInfo basicInfo = new AclPractitionerHiringBasicInfo();
            BeanUtils.copyProperties(requestVO, basicInfo);
            basicInfo.setIsActive(1);

            Date curDate = new Date();
            basicInfo.setCreatedAt(curDate);
            basicInfo.setUpdatedAt(curDate);

            basicInfo.setCreatedBy((long) -1);
            basicInfo.setUpdatedBy((long) -1);

            basicInfoMapper.updateByPrimaryKeySelective(basicInfo);

            resp.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));

        } catch (Exception e) {
            e.printStackTrace();
            resp.setCommonResult(new CommonResult(false, e.getMessage()));
        }
        return resp;
    }

    @Override
    public QueryMembershipResponseVO queryMembership(QueryMembershipRequestVO requestVO) {
        QueryMembershipResponseVO resp = new QueryMembershipResponseVO();
        try {
            AclPractitionerHiringMembership membership = membershipMapper.queryByhiringBasicInfoId(requestVO);

            resp.setMembership(membership);
            resp.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));

        } catch (Exception e) {
            e.printStackTrace();
            resp.setCommonResult(new CommonResult(false, e.getMessage()));
        }
        return resp;
    }

    @Override
    public SaveWorkingExperienceResponseVO saveWorkingExperience(SaveWorkingExperienceRequestVO requestVO) {
        SaveWorkingExperienceResponseVO resp = new SaveWorkingExperienceResponseVO();
        try {
            List<AclPractitionerHiringWorkingExperience> workingExperienceList = requestVO.getWorkingExperienceList();

            Date curDate = new Date();
            workingExperienceList.forEach(item -> {
                item.setIsActive(1);

                item.setCreatedAt(curDate);
                item.setUpdatedAt(curDate);

                item.setCreatedBy((long) -1);
                item.setUpdatedBy((long) -1);
            });

            if (workingExperienceList.size() > 0) {
                workingExperienceMapper.batchInsert(workingExperienceList);
            }

            resp.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));

        } catch (Exception e) {
            e.printStackTrace();
            resp.setCommonResult(new CommonResult(false, e.getMessage()));
        }
        return resp;
    }

    @Override
    public SavePersonPictureResponseVO savePersonPicture(SavePersonPictureRequestVO requestVO) {
        SavePersonPictureResponseVO resp = new SavePersonPictureResponseVO();
        try {
            String mediaId = requestVO.getMediaId();
            String imgUrl = wechatService.getImgUrlByMediaId(mediaId);

            if (imgUrl == null) {
                resp.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("830003")));
            } else {
                AclPractitionerHiringBasicInfo basicInfo = new AclPractitionerHiringBasicInfo();
                basicInfo.setId(requestVO.getHiringBasicInfoId());
                basicInfo.setPersonerPictureOssPath(imgUrl);
                basicInfoMapper.updateByPrimaryKeySelective(basicInfo);

                resp.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
                resp.setImgUrl(imgUrl);
            }
        } catch (Exception e) {
            e.printStackTrace();
            resp.setCommonResult(new CommonResult(false, e.getMessage()));
        }
        return resp;
    }

    @Override
    public SaveIDPictureResponseVO saveIDPicture(SaveIDPictureRequestVO requestVO) {
        SaveIDPictureResponseVO resp = new SaveIDPictureResponseVO();
        try {
            String frontMediaId = requestVO.getFrontMediaId();
            String backMediaId = requestVO.getBackMediaId();

            String frontImgUrl = wechatService.getImgUrlByMediaId(frontMediaId);
            String backImgUrl = wechatService.getImgUrlByMediaId(backMediaId);

            if (frontImgUrl != null && backMediaId != null) {
                AclPractitionerHiringBasicInfo basicInfo = new AclPractitionerHiringBasicInfo();
                basicInfo.setId(requestVO.getHiringBasicInfoId());
                basicInfo.setIdFrontPageOssPath(frontImgUrl);
                basicInfo.setIdBackPageOssPath(backImgUrl);
                basicInfoMapper.updateByPrimaryKeySelective(basicInfo);

                resp.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
                resp.setFrontImgUrl(frontImgUrl);
                resp.setBackImgUrl(backImgUrl);
            } else {
                resp.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("830003")));
            }


        } catch (Exception e) {
            e.printStackTrace();
            resp.setCommonResult(new CommonResult(false, e.getMessage()));
        }
        return resp;
    }

    @Override
    public SaveLastGraduateGradeResponseVO saveLastGraduateGrade(SaveLastGraduateGradeRequestVO requestVO) {
        return null;
    }
}
