package com.yd.dal.entity.customer;

import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
    * 用户财富最终统计结果
    */
@Data
public class AclCustomerFortuneStatistic {
    /**
    * serial id
    */
    private Long id;

    /**
    * FK ag_acl_customer.id
    */
    private Long customerId;

    /**
    * 历史累积财富
    */
    private BigDecimal accumulatedFortune;

    /**
    * 已提现财富
    */
    private BigDecimal drawnFortune;

    /**
    * 已退保财富
    */
    private BigDecimal cancelledFortune;

    /**
    * 注释或补充
    */
    private String remark;

    private Date createdAt;

    private Long createdBy;

    private Date updatedAt;

    /**
    * 变更者 id
    */
    private Long updatedBy;
}