package com.yd.api.practitioner;

import com.yd.api.practitioner.vo.QueryCanSeeResponseVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.yd.api.practitioner.service.PractitionerBasicInfoService;
import com.yd.api.practitioner.service.PractitionerService;
import com.yd.api.practitioner.service.ScheduleTrackService;
import com.yd.api.practitioner.vo.PractitionerIdRequestVO;
import com.yd.api.practitioner.vo.businessCard.PractitionerApplyEmailRequestVO;
import com.yd.api.practitioner.vo.businessCard.PractitionerBusinessCardRequestVO;
import com.yd.api.practitioner.vo.businessCard.PractitionerBusinessCardResponseVO;
import com.yd.api.practitioner.vo.commitment.QueryCommitmentByPractitionerIdResponseVO;
import com.yd.api.practitioner.vo.commitment.SignCommitmentRequestVO;
import com.yd.api.practitioner.vo.informed.QueryInformedSheetByIdResponseVO;
import com.yd.api.practitioner.vo.informed.QueryInformedSheetListRequestVO;
import com.yd.api.practitioner.vo.informed.QueryInformedSheetListResponseVO;
import com.yd.api.practitioner.vo.informed.SaveInformedSheetRequestVO;
import com.yd.api.practitioner.vo.informed.SignInformedSheetRequestVO;
import com.yd.api.practitioner.vo.informed.UpdateInformedSheetByIdRequestVO;
import com.yd.api.practitioner.vo.login.CanSeeSalaryListResponseVO;
import com.yd.api.practitioner.vo.login.PractitionerLoginRequestVO;
import com.yd.api.practitioner.vo.login.PractitionerLoginResponseVO;
import com.yd.api.practitioner.vo.media.MediaGetReqVO;
import com.yd.api.practitioner.vo.media.MediaGetRespVO;
import com.yd.api.practitioner.vo.n22.QuerySalaryDetailRequestVO;
import com.yd.api.practitioner.vo.n22.QuerySalaryDetailResponseVO;
import com.yd.api.practitioner.vo.opportunity.ApplyForExpertSupportRequestVO;
import com.yd.api.practitioner.vo.opportunity.ApplyForExpertSupportResponseVO;
import com.yd.api.practitioner.vo.opportunity.OpportunityDeleteRequestVO;
import com.yd.api.practitioner.vo.opportunity.OpportunityStatisticsRequestVO;
import com.yd.api.practitioner.vo.opportunity.OpportunityStatisticsResponseVO;
import com.yd.api.practitioner.vo.opportunity.OwnOpportunityBasicInformationSaveRequestVO;
import com.yd.api.practitioner.vo.opportunity.OwnOpportunityBasicInformationSaveResponseVO;
import com.yd.api.practitioner.vo.opportunity.OwnOpportunityDetailQueryRequestVO;
import com.yd.api.practitioner.vo.opportunity.OwnOpportunityDetailQueryResponseVO;
import com.yd.api.practitioner.vo.opportunity.OwnOpportunityQueryRequestVO;
import com.yd.api.practitioner.vo.opportunity.OwnOpportunityQueryResponseVO;
import com.yd.api.practitioner.vo.opportunity.OwnOpportunityRecordSaveRequestVO;
import com.yd.api.practitioner.vo.opportunity.OwnOpportunityRecordSaveResponseVO;
import com.yd.api.practitioner.vo.opportunity.PlayerSalesActivityQueryRequestVO;
import com.yd.api.practitioner.vo.opportunity.PlayerSalesActivityQueryResponseVO;
import com.yd.api.practitioner.vo.opportunity.SalesPerformanceForecastListQueryRequestVO;
import com.yd.api.practitioner.vo.opportunity.SalesPerformanceForecastListQueryResponseVO;
import com.yd.api.practitioner.vo.opportunity.SalesScoreDetailQueryRequestVO;
import com.yd.api.practitioner.vo.opportunity.SalesScoreDetailQueryResponseVO;
import com.yd.api.practitioner.vo.organization.OrganizationQueryRequestVO;
import com.yd.api.practitioner.vo.organization.OrganizationQueryResponseVO;
import com.yd.api.practitioner.vo.payscale.PayScalePdfRequestVO;
import com.yd.api.practitioner.vo.payscale.PayScalePdfResponseVO;
import com.yd.api.practitioner.vo.payscale.PayScaleQueryRequestVO;
import com.yd.api.practitioner.vo.payscale.PayScaleQueryResponseVO;
import com.yd.api.practitioner.vo.policy.PolicyListQueryRequestVO;
import com.yd.api.practitioner.vo.policy.PolicyListQueryResponseVO;
import com.yd.api.practitioner.vo.policy.policyinfoquery.PolicyInfoQueryRequestVO;
import com.yd.api.practitioner.vo.policy.policyinfoquery.PolicyInfoQueryResponseVO;
import com.yd.api.practitioner.vo.practitionerCustomer.QueryCustomerHolderListResponesVO;
import com.yd.api.practitioner.vo.practitionerCustomer.QueryCustomerInsuredListRequestVO;
import com.yd.api.practitioner.vo.practitionerCustomer.QueryCustomerInsuredListResponesVO;
import com.yd.api.practitioner.vo.practitionerCustomer.QueryPolicyListByHolderCustomerIdRequestVO;
import com.yd.api.practitioner.vo.practitionerCustomer.QueryPolicyListByHolderCustomerIdResponesVO;
import com.yd.api.practitioner.vo.rank.PractitionerRankRequestVO;
import com.yd.api.practitioner.vo.rank.PractitionerRankResponseVO;
import com.yd.api.practitioner.vo.recruit.AddRecruitTrackRequestVO;
import com.yd.api.practitioner.vo.recruit.AddRecruitTrackResponseVO;
import com.yd.api.practitioner.vo.recruit.PotentialActivityQueryRequestVO;
import com.yd.api.practitioner.vo.recruit.PotentialActivityQueryResponseVO;
import com.yd.api.practitioner.vo.recruit.PotentialGoalsActionsQueryRequestVO;
import com.yd.api.practitioner.vo.recruit.PotentialGoalsActionsQueryResponseVO;
import com.yd.api.practitioner.vo.recruit.PotentialGoalsActionsUpdateRequestVO;
import com.yd.api.practitioner.vo.recruit.PotentialGoalsActionsUpdateResponseVO;
import com.yd.api.practitioner.vo.recruit.PotentialGoalsQueryRequestVO;
import com.yd.api.practitioner.vo.recruit.PotentialGoalsQueryResponseVO;
import com.yd.api.practitioner.vo.recruit.PotentialGoalsSettingRequestVO;
import com.yd.api.practitioner.vo.recruit.PotentialGoalsSettingResponseVO;
import com.yd.api.practitioner.vo.recruit.RecruitListRequestVO;
import com.yd.api.practitioner.vo.recruit.RecruitListResponseVO;
import com.yd.api.practitioner.vo.recruit.RecruitRequestVO;
import com.yd.api.practitioner.vo.recruit.RecruitResponseVO;
import com.yd.api.practitioner.vo.recruit.RecruitTrackQueryRequestVO;
import com.yd.api.practitioner.vo.recruit.RecruitTrackQueryResponseVO;
import com.yd.api.practitioner.vo.salestarget.SalesTargetMonthSaveRequestVO;
import com.yd.api.practitioner.vo.salestarget.SalesTargetMonthSaveResponseVO;
import com.yd.api.practitioner.vo.salestarget.SalesTargetQueryRequestVO;
import com.yd.api.practitioner.vo.salestarget.SalesTargetQueryResponseVO;
import com.yd.api.practitioner.vo.salestarget.SalesTargetSaveRequestVO;
import com.yd.api.practitioner.vo.salestarget.SalesTargetSaveResponseVO;
import com.yd.api.practitioner.vo.salestarget.TeamActionsAverageQueryRequestVO;
import com.yd.api.practitioner.vo.salestarget.TeamActionsAverageQueryResponseVO;
import com.yd.api.practitioner.vo.sechedule.AddScheduleTrackRequestVO;
import com.yd.api.practitioner.vo.sechedule.AddScheduleTrackResponseVO;
import com.yd.api.practitioner.vo.sechedule.DeleteScheduleByIdResponseVO;
import com.yd.api.practitioner.vo.sechedule.DeleteScheduleTrackByIdRequestVO;
import com.yd.api.practitioner.vo.sechedule.QueryPEPScoreDetailRequestVO;
import com.yd.api.practitioner.vo.sechedule.QueryPEPScoreDetailResponseVO;
import com.yd.api.practitioner.vo.sechedule.QueryPEPScoreRequestVO;
import com.yd.api.practitioner.vo.sechedule.QueryPEPScoreResponseVO;
import com.yd.api.practitioner.vo.sechedule.QueryScheduleTrackListRequestVO;
import com.yd.api.practitioner.vo.sechedule.QueryScheduleTrackListResponseVO;
import com.yd.api.practitioner.vo.setting.ImgDeleteRequestVO;
import com.yd.api.practitioner.vo.setting.ImgDeleteResponseVO;
import com.yd.api.practitioner.vo.setting.SettingQueryRequestVO;
import com.yd.api.practitioner.vo.setting.SettingQueryResponseVO;
import com.yd.api.practitioner.vo.setting.SettingSaveRequestVO;
import com.yd.api.practitioner.vo.setting.SettingSaveResponseVO;
import com.yd.api.practitioner.vo.subordinate.QueryTeamMemberDetailRequestVO;
import com.yd.api.practitioner.vo.subordinate.QueryTeamMemberDetailResponseVO;
import com.yd.api.practitioner.vo.subordinate.SubordinateSystemMemberQueryRequestVO;
import com.yd.api.practitioner.vo.subordinate.SubordinateSystemMemberQueryResponseVO;
import com.yd.api.practitioner.vo.unionSales.SignUnionSalesRequestVO;
import com.yd.api.result.CommonResultIDResponseVO;
import com.yd.api.result.CommonResultResponseVO;
import com.yd.api.result.IDRequestVO;
import com.yd.api.result.JsonResult;
import com.yd.rmi.n22.policy.service.N22PolicyService;
import com.yd.rmi.n22.salary.pojo.searchstaffsalarydetails.SearchStaffSalaryDetailsRequestBody;
import com.yd.rmi.n22.salary.pojo.searchstaffsalarydetails.SearchStaffSalaryDetailsResponseBody;
import com.yd.rmi.n22.staff.service.N22StaffService;


@Controller
@RestController
@RequestMapping("/practitioner")
public class PractitionerController {

    @Autowired
    private PractitionerService practitionerService;
    @Autowired
    private PractitionerBasicInfoService practitionerBasicInfoService;
    @Autowired
    private ScheduleTrackService scheduleTrackService;
    @Autowired
    private N22PolicyService n22PolicyService;
    @Autowired
    private N22StaffService n22StaffService;
    /**
     * 经纪人登录
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/login")
    public Object practitionerLogin(@RequestBody PractitionerLoginRequestVO requestVO){
        JsonResult result = new JsonResult();
        PractitionerLoginResponseVO responseVO = practitionerService.practitionerLogin(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 经纪人（排行榜） + （保费+佣金+件数）查询
     * @param  requestVO 请求数据
     * @return Object
     */
    @RequestMapping("/rank")
    public Object practitionerRank(@RequestBody PractitionerRankRequestVO requestVO){
        JsonResult result = new JsonResult();
        PractitionerRankResponseVO responseVO = practitionerService.practitionerRank(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 经纪人-查询经纪人的个人设置
     * @param requestVO 请求数据
     * @return responseVO
     */
    @RequestMapping("/settingQuery")
    public Object settingQuery(@RequestBody SettingQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        SettingQueryResponseVO responseVO = practitionerService.settingQuery(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * 经纪人-查询经纪人银盾学院权限
     * @param requestVO 请求数据
     * @return responseVO
     */
    @RequestMapping("/queryCanSee")
    public Object queryCanSee(@RequestBody SettingQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        QueryCanSeeResponseVO responseVO = practitionerService.queryCanSee(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * 经纪人-保存经纪人的个人设置
     * @param requestVO 请求数据
     * @return responseVO
     */
    @RequestMapping("/settingSave")
    public Object mySettingSave(@RequestBody SettingSaveRequestVO requestVO) throws Exception {
        JsonResult result = new JsonResult();
        SettingSaveResponseVO responseVO = practitionerService.settingSave(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * 经纪人-删除经纪人照片
     */
    @RequestMapping("/imgDelete")
    public Object imgDelete(@RequestBody ImgDeleteRequestVO requestVO){
        JsonResult result = new JsonResult();
        ImgDeleteResponseVO responseVO = practitionerService.imgDelete(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * 微信-上传多媒体文件
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/mediaGet")
    public Object mediaGet(@RequestBody MediaGetReqVO requestVO){
        JsonResult result = new JsonResult();
        MediaGetRespVO responseVO = practitionerService.mediaGet(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /***
     * 经纪人-经纪人查询自己的商机
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/ownOpportunityQuery")
    public Object ownOpportunityQuery(@RequestBody OwnOpportunityQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        OwnOpportunityQueryResponseVO responseVO = practitionerService.ownOpportunityQuery(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }
    /**
     * 团队长--新增增员
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/recruit")
    public Object recruit(@RequestBody RecruitRequestVO requestVO){
        JsonResult result = new JsonResult();
        RecruitResponseVO responseVO = practitionerService.recruit(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /***
     * 经纪人-经纪人查询自己的商机详情查询
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/ownOpportunityDetailQuery")
    public Object ownOpportunityDetailQuery(@RequestBody OwnOpportunityDetailQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        OwnOpportunityDetailQueryResponseVO responseVO = practitionerService.ownOpportunityDetailQuery(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }
    /**
     * 团队长--新增增员记录
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/addRecruitTrack")
    public Object addRecruitTrack(@RequestBody AddRecruitTrackRequestVO requestVO){
        JsonResult result = new JsonResult();
        AddRecruitTrackResponseVO responseVO = practitionerService.addRecruitTrack(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 团队长--增员记录查询
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/recruitTrackQuery")
    public Object recruitTrackQuery(@RequestBody RecruitTrackQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        RecruitTrackQueryResponseVO responseVO = practitionerService.recruitTrackQuery(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 团队长--增员列表查询
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/recruitListQuery")
    public Object recruitListQuery(@RequestBody RecruitListRequestVO requestVO){
        JsonResult result = new JsonResult();
        RecruitListResponseVO responseVO = practitionerService.recruitListQuery(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 经纪人-修改商机基本信息
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/ownOpportunityBasicInformationSave")
    public Object ownOpportunityBasicInformationSave(@RequestBody OwnOpportunityBasicInformationSaveRequestVO requestVO){
        JsonResult result = new JsonResult();
        OwnOpportunityBasicInformationSaveResponseVO responseVO = practitionerService.ownOpportunityBasicInformationSave(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 经纪人-保存商机跟进,修改商机基本信息
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/ownOpportunityRecordSave")
    public Object ownOpportunityRecordSave(@RequestBody OwnOpportunityRecordSaveRequestVO requestVO){
        JsonResult result = new JsonResult();
        OwnOpportunityRecordSaveResponseVO responseVO = practitionerService.ownOpportunityRecordSave(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 经纪人-ydLife查询此经纪人总分数  按年月周日 分别统计  新增商机个数  达成率
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/opportunityStatistics")
    public Object OpportunityStatistics(@RequestBody OpportunityStatisticsRequestVO requestVO){
        JsonResult result = new JsonResult();
        OpportunityStatisticsResponseVO responseVO = practitionerService.opportunityStatistics(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }
    /**
     * 团队长--设置增员目标
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/potentialGoalsSetting")
    public Object potentialGoalsSetting(@RequestBody PotentialGoalsSettingRequestVO requestVO){
        JsonResult result = new JsonResult();
        PotentialGoalsSettingResponseVO responseVO = practitionerService.potentialGoalsSetting(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 经纪人-保存销售目标
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/salesTargetSave")
    public Object salesTargetSave(@RequestBody SalesTargetSaveRequestVO requestVO){
        JsonResult result = new JsonResult();
        SalesTargetSaveResponseVO responseVO = practitionerService.salesTargetSave(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }
    /**
     * 团队长--查询增员目标
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/potentialGoalsQuery")
    public Object potentialGoalsQuery(@RequestBody PotentialGoalsQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        PotentialGoalsQueryResponseVO responseVO = practitionerService.potentialGoalsQuery(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 经纪人-查询销售目标
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/salesTargetQuery")
    public Object salesTargetQuery(@RequestBody SalesTargetQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        SalesTargetQueryResponseVO responseVO = practitionerService.salesTargetQuery(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }
    /**
     * 团队长--查询增员目标活动量
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/potentialGoalsActionsQuery")
    public Object potentialGoalsActionsQuery(@RequestBody PotentialGoalsActionsQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        PotentialGoalsActionsQueryResponseVO responseVO = practitionerService.potentialGoalsActionsQuery(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 经纪人-保存月均目标
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/salesTargetMonthSave")
    public Object salesTargetMonthSave(@RequestBody SalesTargetMonthSaveRequestVO requestVO){
        JsonResult result = new JsonResult();
        SalesTargetMonthSaveResponseVO responseVO = practitionerService.salesTargetMonthSave(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }
    /**
     * 团队长--更新增员目标活动量
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/potentialGoalsActionsUpdate")
    public Object potentialGoalsActionsUpdate(@RequestBody PotentialGoalsActionsUpdateRequestVO requestVO){
        JsonResult result = new JsonResult();
        PotentialGoalsActionsUpdateResponseVO responseVO = practitionerService.potentialGoalsActionsUpdate(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 团队长-查看组员得分均值
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/teamActionsAverageQuery")
    public Object teamActionsAverageQuery(@RequestBody TeamActionsAverageQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        TeamActionsAverageQueryResponseVO responseVO = practitionerService.teamScoreAverageQuery(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }
    /**
     * 团队长--查看目前活动量
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/potentialActivityQuery")
    public Object potentialActivityQuery(@RequestBody PotentialActivityQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        PotentialActivityQueryResponseVO responseVO = practitionerService.potentialActivityQuery(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 队员销售活动量列表
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/playerSalesActivityQuery")
    public Object playerSalesActivityQuery(@RequestBody PlayerSalesActivityQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        PlayerSalesActivityQueryResponseVO responseVO = practitionerService.playerSalesActivityQuery(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 销售业绩预测  保费/佣金/件数  月季年
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/salesPerformanceForecastListQuery")
    public Object salesPerformanceForecastListQuery(@RequestBody SalesPerformanceForecastListQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        SalesPerformanceForecastListQueryResponseVO responseVO = practitionerService.salesPerformanceForecastListQuery(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }
    /**
     * 体系团队成员信息查询
     * @param requestVO 请求数据
     * @return AnnouncementQueryResponseVO
     */
    @RequestMapping("/subordinateSystemMemberQuery")
    public Object subordinateSystemMemberQuery(@RequestBody SubordinateSystemMemberQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        SubordinateSystemMemberQueryResponseVO responseVO = practitionerService.subordinateSystemMemberQuery(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * 经纪人-查看自己销售活动量分值详情
     */
    @RequestMapping("salesScoreDetailQuery")
    public Object salesScoreDetailQuery (@RequestBody SalesScoreDetailQueryRequestVO requestVO ){
        JsonResult result = new JsonResult();
        SalesScoreDetailQueryResponseVO responseVO = practitionerService.salesScoreDetailQuery(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }
    /**
     * 经纪人保单列表查询接口
     * @param requestVO 请求信息
     * @return PolicyListQueryResponseVO
     */
    @RequestMapping("/policyListQuery")
    public Object practitionerPolicyListQuery(@RequestBody PolicyListQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        PolicyListQueryResponseVO responseVO = practitionerBasicInfoService.policyListQuery(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * 经纪人保单详情查询接口
     * @param requestVO 请求信息
     * @return PolicyInfoQueryResponseVO
     */
    @RequestMapping("/policyInfoQuery")
    public Object policyInfoQuery(@RequestBody PolicyInfoQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        PolicyInfoQueryResponseVO responseVO = practitionerBasicInfoService.policyInfoQuery(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * 经纪人薪资表查询接口
     * @param requestVO 请求信息
     * @return PolicyInfoQueryResponseVO
     */
    @RequestMapping("/payScaleListQuery")
    public Object payScaleListQuery(@RequestBody PayScaleQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        PayScaleQueryResponseVO responseVO = practitionerBasicInfoService.payScaleListQuery(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * 薪资单明细保单列表查询接口
     *
     * @param requestVO 请求信息
     * @return PolicyInfoQueryResponseVO
     */
    @RequestMapping("/searchStaffSalaryDetails")
    public Object searchStaffSalaryDetails(@RequestBody SearchStaffSalaryDetailsRequestBody requestVO){
        JsonResult result = new JsonResult();
        SearchStaffSalaryDetailsResponseBody responseVO = practitionerBasicInfoService.searchStaffSalaryDetails(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * 经纪人薪资单明细查询接口
     * @param requestVO 请求信息
     * @return PolicyInfoQueryResponseVO
     */
    @RequestMapping("/querySalaryDetail")
    public Object querySalaryDetail(@RequestBody QuerySalaryDetailRequestVO requestVO){
        JsonResult result = new JsonResult();
        QuerySalaryDetailResponseVO responseVO = practitionerBasicInfoService.querySalaryDetail(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }


    /**
     * 获取经纪人的薪资表
     * @param requestVO 请求信息
     * @return 返回信息
     */
    @PostMapping(value = "/payScalePdf")
    public Object payScalePdf(@RequestBody PayScalePdfRequestVO requestVO){
        JsonResult result = new JsonResult();
        PayScalePdfResponseVO responseVO =  practitionerBasicInfoService.payScalePdf(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * 申请专家支持
     * @param requestVO 请求信息
     * @return 返回信息
     */
    @PostMapping(value = "/applyForExpertSupport")
    public Object applyForExpertSupport(@RequestBody ApplyForExpertSupportRequestVO requestVO){
        JsonResult result = new JsonResult();
        ApplyForExpertSupportResponseVO responseVO =  practitionerService.applyForExpertSupport(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }
    /**
     *
     * @param requestVO
     * @return
     */
    @RequestMapping("/organizationQuery")
    public Object organizationQuery(@RequestBody OrganizationQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        OrganizationQueryResponseVO responseVO = practitionerBasicInfoService.organizationQuery(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 新建日程
     * @param requestVO
     * @return
     */
    @RequestMapping("/addScheduleTrack")
    public Object addScheduleTrack(@RequestBody AddScheduleTrackRequestVO requestVO){
        JsonResult result = new JsonResult();
        AddScheduleTrackResponseVO responseVO = scheduleTrackService.insert(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 根据经纪人id查询日程列表
     * @param requestVO
     * @return
     */
    @RequestMapping("/queryScheduleTrackList")
    public Object queryScheduleTrackList(@RequestBody QueryScheduleTrackListRequestVO requestVO){
        JsonResult result = new JsonResult();
        QueryScheduleTrackListResponseVO responseVO = scheduleTrackService.queryScheduleTrackList(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 根据id删除日程记录
     * @param requestVO
     * @return
     */
    @RequestMapping("/deleteScheduleTrackById")
    public Object deleteScheduleTrackById(@RequestBody DeleteScheduleTrackByIdRequestVO requestVO){
        JsonResult result = new JsonResult();
        DeleteScheduleByIdResponseVO responseVO = scheduleTrackService.deleteScheduleTrackById(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 查询战队PEP得分
     * @param requestVO
     * @return
     */
    @RequestMapping("/queryPEPScore")
    public Object queryPEPScore(@RequestBody QueryPEPScoreRequestVO requestVO){
        JsonResult result = new JsonResult();
        QueryPEPScoreResponseVO responseVO = scheduleTrackService.queryPEPScore(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 查询个人PEP得分详情
     * @param requestVO
     * @return
     */
    @RequestMapping("/queryPEPScoreDetail")
    public Object queryPEPScoreDetail(@RequestBody QueryPEPScoreDetailRequestVO requestVO){
        JsonResult result = new JsonResult();
        QueryPEPScoreDetailResponseVO responseVO = scheduleTrackService.queryPEPScoreDetail(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 查询经纪人战队成员信息
     * @param requestVO
     * @return
     */
    @RequestMapping("/queryTeamMemberDetail")
    public Object queryTeamMemberDetail(@RequestBody QueryTeamMemberDetailRequestVO requestVO){
        JsonResult result = new JsonResult();
        QueryTeamMemberDetailResponseVO responseVO = practitionerBasicInfoService.queryTeamMemberDetail(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 查询经纪人是否可以看薪资表
     * @return
     */
    @RequestMapping("/canSeeSalaryList/{practitionerId}")
    public Object canSeeSalaryList(@PathVariable Long practitionerId){
        JsonResult result = new JsonResult();
        CanSeeSalaryListResponseVO responseVO = practitionerService.canSeeSalaryList(practitionerId);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    @RequestMapping("/queryCustomerHolderList/{practitionerId}")
    public Object queryCustomerHolderList(@PathVariable Long practitionerId) {
        JsonResult result = new JsonResult();
        QueryCustomerHolderListResponesVO responseVO = practitionerService.queryCustomerHolderList(practitionerId);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    @RequestMapping("/queryCustomerInsuredList")
    public Object queryCustomerInsuredList(@RequestBody QueryCustomerInsuredListRequestVO requestVO) {
        JsonResult result = new JsonResult();
        QueryCustomerInsuredListResponesVO responseVO = practitionerService.queryCustomerInsuredList(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    @RequestMapping("/queryPolicyListByHolderCustomerId")
    public Object queryPolicyListByHolderCustomerId(@RequestBody QueryPolicyListByHolderCustomerIdRequestVO requestVO) {
        JsonResult result = new JsonResult();
        QueryPolicyListByHolderCustomerIdResponesVO responseVO = practitionerService.queryPolicyListByHolderCustomerId(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    @RequestMapping("/saveInformedSheet")
    public Object saveInformedSheet(@RequestBody SaveInformedSheetRequestVO requestVO) {
        JsonResult result = new JsonResult();
        CommonResultIDResponseVO responseVO = practitionerService.saveInformedSheet(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    @RequestMapping("/updateInformedSheetById")
    public Object updateInformedSheetById(@RequestBody UpdateInformedSheetByIdRequestVO requestVO) {
        JsonResult result = new JsonResult();
        CommonResultIDResponseVO responseVO = practitionerService.updateInformedSheetById(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    @RequestMapping("/queryInformedSheetById")
    public Object queryInformedSheetById(@RequestBody IDRequestVO requestVO) {
        JsonResult result = new JsonResult();
        QueryInformedSheetByIdResponseVO responseVO = practitionerService.queryInformedSheetById(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }
    
    @RequestMapping("/deleteInformedSheetById")
    public Object deleteInformedSheetById(@RequestBody IDRequestVO requestVO) {
        JsonResult result = new JsonResult();
        CommonResultResponseVO responseVO = practitionerService.deleteInformedSheetById(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    @RequestMapping("/signInformedSheet")
    public Object signInformedSheet(@RequestBody SignInformedSheetRequestVO requestVO) {
        JsonResult result = new JsonResult();
        CommonResultIDResponseVO responseVO = practitionerService.signInformedSheet(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    @RequestMapping("/queryInformedSheetList")
    public Object queryInformedSheetList(@RequestBody QueryInformedSheetListRequestVO requestVO) {
        JsonResult result = new JsonResult();
        QueryInformedSheetListResponseVO responseVO = practitionerService.queryInformedSheetList(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    @RequestMapping("/signCommitment")
    public Object signCommitment(@RequestBody SignCommitmentRequestVO requestVO) {
        JsonResult result = new JsonResult();
        CommonResultIDResponseVO responseVO = practitionerService.signCommitment(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    @RequestMapping("/queryCommitmentByPractitionerId")
    public Object queryCommitmentByPractitionerId(@RequestBody PractitionerIdRequestVO requestVO) {
        JsonResult result = new JsonResult();
        QueryCommitmentByPractitionerIdResponseVO responseVO = practitionerService.queryCommitmentByPractitionerId(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }
    
    /**
     * 经纪人联合销售签名
     * @param SignUnionSalesRequestVO
     * @return CommonResultIDResponseVO
     * @author Yan Wenyang
     */
    @RequestMapping("/signUnionSales")
    public Object signUnionSales(@RequestBody SignUnionSalesRequestVO requestVO) {
        JsonResult result = new JsonResult();
        CommonResultIDResponseVO responseVO = practitionerService.signUnionSales(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 逻辑删除商机
     * @param OpportunityDeleteRequestVO
     * @return CommonResultIDResponseVO
     * @author Yan Wenyang
     */
    @RequestMapping("/deleteOpportunity")
    public Object deleteOpportunity(@RequestBody OpportunityDeleteRequestVO requestVO) {
        JsonResult result = new JsonResult();
        CommonResultIDResponseVO responseVO = practitionerService.updateOpportunity(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }
    
    /**
     * 经纪人名片
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/businessCard")
    public Object businessCard(@RequestBody PractitionerBusinessCardRequestVO requestVO){
        JsonResult result = new JsonResult();
        PractitionerBusinessCardResponseVO responseVO = practitionerService.businessCard(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 经纪人申请开通邮箱
     * @param PractitionerApplyEmailRequestVO
     * @return CommonResultResponseVO
     * @author Yan Wenyang
     */
    @RequestMapping("/applyEmail")
    public Object applyEmail(@RequestBody PractitionerApplyEmailRequestVO requestVO) {
        JsonResult result = new JsonResult();
        CommonResultResponseVO responseVO = practitionerService.applyEmail(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }
}
