package com.yd.api.practitioner.service.impl;

import com.yd.api.practitioner.service.PractitionerArticleService;
import com.yd.api.practitioner.vo.ArticleTrackSaveResponseVO;
import com.yd.api.practitioner.vo.article.ArticleShareCodeSaveRequestVO;
import com.yd.api.practitioner.vo.article.ArticleShareCodeSaveResponseVO;
import com.yd.api.practitioner.vo.article.ArticleTrackSaveRequestVO;
import com.yd.api.result.CommonResult;
import com.yd.dal.entity.customer.AclCustomerObjectShare;
import com.yd.dal.entity.customer.AclCustomerObjectShareTrack;
import com.yd.dal.service.customer.AclCustomerObjectShareDALService;
import com.yd.dal.service.customer.AclCustomerObjectShareTrackDALService;
import com.yd.util.CommonUtil;
import com.yd.util.config.ZHBErrorConfig;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service("practitionerArticleService")
public class PractitionerArticleServiceImpl implements PractitionerArticleService {
    @Autowired
    private AclCustomerObjectShareDALService aclCustomerObjectShareDALService;
    @Autowired
    private AclCustomerObjectShareTrackDALService aclCustomerObjectShareTrackDALService;

    @Override
    public ArticleShareCodeSaveResponseVO articleShareCodeSave(ArticleShareCodeSaveRequestVO requestVO) {
        ArticleShareCodeSaveResponseVO responseVO = new ArticleShareCodeSaveResponseVO();
        AclCustomerObjectShare objectShare = new AclCustomerObjectShare();
        BeanUtils.copyProperties(requestVO,objectShare);
        objectShare.setItemType(1);
        objectShare.setCreatedAt(new Date());
        objectShare.setCreatedBy(-1L);
        Long id = aclCustomerObjectShareDALService.save(objectShare);
        responseVO.setId(id);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    @Override
    public ArticleTrackSaveResponseVO articleTrackSave(ArticleTrackSaveRequestVO requestVO) {
        ArticleTrackSaveResponseVO responseVO = new ArticleTrackSaveResponseVO();
        AclCustomerObjectShareTrack shareTrack = new AclCustomerObjectShareTrack();
        BeanUtils.copyProperties(requestVO,shareTrack);
        shareTrack.setCreatedAt(new Date());
        shareTrack.setCreatedBy(-1L);
        Long id = requestVO.getId();
        if (CommonUtil.isNullOrZero(id)){
            shareTrack.setTrackInTime(CommonUtil.stringParseDate(requestVO.getTrackInTime(),"yyyy-MM-dd HH:mm:ss"));
            id = aclCustomerObjectShareTrackDALService.save(shareTrack);
        }else {
            shareTrack.setTrackOutTime(CommonUtil.stringParseDate(requestVO.getTrackOutTime(),"yyyy-MM-dd HH:mm:ss"));
            aclCustomerObjectShareTrackDALService.update(shareTrack);
        }
        responseVO.setId(id);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }
}
