package com.yd.api.market;

import com.yd.api.market.service.MarketService;
import com.yd.api.market.vo.announcement.AnnouncementQueryRequestVO;
import com.yd.api.market.vo.announcement.AnnouncementQueryResponseVO;
import com.yd.api.market.vo.poster.PosterQueryRequestVO;
import com.yd.api.market.vo.poster.PosterQueryResponseVO;
import com.yd.api.result.JsonResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MarketController {

    @Autowired
    private MarketService marketService;

    /**
     * 市场公告查询接口
     * @param requestVO
     * @return AnnouncementQueryResponseVO
     */
    @RequestMapping("/announcementQuery")
    public Object announcementQuery(@RequestBody AnnouncementQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        AnnouncementQueryResponseVO responseVO = marketService.announcementQuery(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * 海报查询接口
     * @param requestVO
     * @return AnnouncementQueryResponseVO
     */
    @RequestMapping("/posterQuery")
    public Object posterQuery(@RequestBody PosterQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        PosterQueryResponseVO responseVO = marketService.posterQuery(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }
}
