package com.yd.dal.service.marketing.Impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import com.yd.dal.entity.marketing.MktLeadsAssignedTrack;
import com.yd.dal.mapper.marketing.MktLeadsAssignedTrackMapper;
import com.yd.dal.service.marketing.MktLeadsAssignedTrackDALService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service("mktLeadsAssignedTrackDALService")
public class MktLeadsAssignedTrackDALServiceImpl implements MktLeadsAssignedTrackDALService {
    @Resource
    private MktLeadsAssignedTrackMapper mktLeadsAssignedTrackMapper;

    @Override
    public List<MktLeadsAssignedTrack> findByMktLeadsAssignedTrack(MktLeadsAssignedTrack mktLeadsAssignedTrack) {
        Page<MktLeadsAssignedTrack> destList =  mktLeadsAssignedTrackMapper.selectByPrimaryKeySelective(mktLeadsAssignedTrack);
        PageInfo<MktLeadsAssignedTrack> pageInfo = new PageInfo<>(destList);
        List<MktLeadsAssignedTrack> list = pageInfo.getList();
        return list;
    }

    @Override
    public void saveTrack(MktLeadsAssignedTrack track) {
        mktLeadsAssignedTrackMapper.insertSelective(track);
    }

    @Override
    public void updateTrack(MktLeadsAssignedTrack track) {
        mktLeadsAssignedTrackMapper.updateByPrimaryKeySelective(track);
    }

    @Override
    public List<MktLeadsAssignedTrack> findByTrackTimeForNew(MktLeadsAssignedTrack mktLeadsAssignedTrack) {
        return mktLeadsAssignedTrackMapper.findByTrackTimeForNew(mktLeadsAssignedTrack);
    }

    @Override
    public List<Integer> totalStatisticsForTeam(List<Long> practitionerIds) {
        return mktLeadsAssignedTrackMapper.totalStatisticsForTeam(practitionerIds);
    }
}
