package com.yd.rmi.n22.salary.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.yd.rmi.n22.common.utils.N22Utils;
import com.yd.rmi.n22.salary.pojo.SalaryDetails;
import com.yd.rmi.n22.salary.pojo.SalaryDetailsSearchRequestBody;
import com.yd.rmi.n22.salary.pojo.SalaryDetailsSearchResponseVO;
import com.yd.rmi.n22.salary.service.N22SalaryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
public class N22SalaryServiceImpl implements N22SalaryService {

    private final static Logger logger = LoggerFactory.getLogger(N22SalaryServiceImpl.class);

    @Override
    public SalaryDetailsSearchResponseVO salaryDetailsSearch(SalaryDetailsSearchRequestBody salaryDetailsSearchRequestBody) {
        JSONObject obj = new JSONObject(); //传参
        JSONObject rObj; //返回结果

        JSONObject requestHead = new JSONObject();
        requestHead.put("seqNo", UUID.randomUUID().toString());

        obj.put("requestHead", requestHead);
        obj.put("requestBody", salaryDetailsSearchRequestBody);
        logger.info("N22佣金明细查询请求报文："+obj.toString());

//        String url = "https://life.ydinsurance.cn/EliteGeneralHttpTask/GeneralService/SalaryDetailsSearch";
        String url = "http://101.132.32.185:8082/EliteGeneralHttpTask/GeneralService/SalaryDetailsSearch";
        String result = N22Utils.postTransaction(url, obj.toString());

        logger.info("N22佣金明细查询响应报文："+result);
        SalaryDetailsSearchResponseVO response = JSONObject.parseObject(result, SalaryDetailsSearchResponseVO.class);


        return response;
    }

    @Override
    public Map<String, List<SalaryDetails>> groupByYearmonth(List<SalaryDetails> salaryDetailsList) {
        Map<String, List<SalaryDetails>> result = new HashMap<String, List<SalaryDetails>>();
        int year = 0;
        String month = "";
        String key = "";
        for (SalaryDetails SalaryDetails : salaryDetailsList) {
            year = SalaryDetails.getYear();
            month = SalaryDetails.getMonth();
            key = year + month;

            List<SalaryDetails> childList = result.get(key);
            if (childList == null) {
                childList = new ArrayList<SalaryDetails>();
                result.put(key, childList);
            }

            childList.add(SalaryDetails);
        }
        result.forEach((cc, list) -> {
            System.out.println("CheckDate is:" + cc);
            list.forEach((SalaryDetails) -> {
                System.out.println("SalaryDetails is:" + SalaryDetails);
            });
        });
        return result;
    }
}
