package com.yd.api.commission.service;

import java.util.ArrayList;
import java.util.List;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import com.yd.api.agms.vo.statement.PredictStatementData;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.yd.api.commission.vo.CommissionEGoldenVO;
import com.yd.api.commission.vo.CommissionVO;
import com.yd.dal.entity.commission.Commission;
import com.yd.dal.entity.commission.CommissionEGolden;
import com.yd.dal.service.commission.CommissionEGoldenDA;
import com.yd.dal.service.commission.CommissionServiceDA;

@Service("commissionService")
public class CommissionServiceImpl implements CommissionService{

	@Autowired
    private CommissionServiceDA commissionServiceDA;
	@Autowired
    private CommissionEGoldenDA commissionEGoldenDA;
	/*
	 * 按照手机号从AGMS DB中查询佣金
	 * (non-Javadoc)
	 * @see com.yd.api.commission.service.CommissionService#queryCommissionByLogin(java.lang.String)
	 */
	@Override
	public List<CommissionVO> queryCommissionByLogin(String login) {
		List<CommissionVO> listTo =new ArrayList<CommissionVO>();
		List<Commission> list = new ArrayList<Commission>();
		list = commissionServiceDA.queryCommissionByLogin(login);
		CommissionVO oneDestVO;
    	for(Commission oneSrc:list)
    	{
    		oneDestVO = new CommissionVO();
    		BeanUtils.copyProperties(oneSrc, oneDestVO);
    		listTo.add(oneDestVO);
    	}
		return listTo;
	}
	/*
	 * 按照手机号从EGolden DB中查询用户保单列表
	 * (non-Javadoc)
	 * @see com.yd.api.commission.service.CommissionService#listSalesCommissionfromEGolden(java.lang.String)
	 */
	@Override
	public List<CommissionEGoldenVO> listSalesCommissionfromEGolden(String login) {
		List<CommissionEGoldenVO> listTo =new ArrayList<CommissionEGoldenVO>();
		List<CommissionEGolden> list = new ArrayList<CommissionEGolden>();
		list = commissionEGoldenDA.listSalesCommissionfromEGolden(login);
		CommissionEGoldenVO oneDestVO;
    	for(CommissionEGolden oneSrc:list)
    	{
    		oneDestVO = new CommissionEGoldenVO();
    		BeanUtils.copyProperties(oneSrc, oneDestVO);
    		listTo.add(oneDestVO);
    	}
		return listTo;
	}

	@Override
	public PageInfo<PredictStatementData> getPredictStatementDataByPage(int pageNum, int size, String predictInCommissionTime, String predictOutCommissionTime, String insurerBranchId, String deptId, String subordinateId) {
		return CommissionEGoldenDA.getPredictStatementDataByPage(pageNum,size,predictInCommissionTime,predictOutCommissionTime,insurerBranchId,deptId,subordinateId);
	}
}

