package com.yd.dal.service.agms.impl;

import com.yd.dal.entity.agms.fortune.*;
import com.yd.dal.mapper.agms.AgmsFortuneMapper;
import com.yd.dal.service.agms.AgmsFortuneDALService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;

/**
 * @author xxy
 */
@Service("agmsFortuneDALService")
public class AgmsFortuneDALServiceImpl implements AgmsFortuneDALService {

    @Autowired
    private AgmsFortuneMapper agmsFortuneMapper;

    @Override
    public Map<Long,CustomerFortuneStatisticalInfo> findFortuneStatisticalByCustomers(Set<Long> customerIds) {
        List<Long> customerIdList = new ArrayList<>(customerIds);
        List<CustomerFortuneStatisticalInfo> statisticalInfoList = agmsFortuneMapper.findFortuneStatisticalByCustomers(customerIdList);
        Map<Long,CustomerFortuneStatisticalInfo> customerFortuneStatisticalMap = new HashMap<>(statisticalInfoList.size());
        for (CustomerFortuneStatisticalInfo statisticalInfo: statisticalInfoList){
            //可提现金额 历史累积财富-已提现财富-已退保财富-暂不可提现财富-申请中
            BigDecimal cashableFortune = statisticalInfo.getAccumulatedFortune()
                    .subtract(statisticalInfo.getUncashableFortune())
                    .subtract(statisticalInfo.getDrawnFortune())
                    .subtract(statisticalInfo.getCancelledFortune())
                    .subtract(statisticalInfo.getProcessing());
            statisticalInfo.setCashableFortune(cashableFortune);
            //计算剩余总财富 历史累积财富-已提现财富-已退保财富
            BigDecimal totalFortune = statisticalInfo.getAccumulatedFortune()
                    .subtract(statisticalInfo.getDrawnFortune())
                    .subtract(statisticalInfo.getCancelledFortune());
            statisticalInfo.setTotalFortune(totalFortune);
            //净资产  历史累积财富-已提现财富
            BigDecimal netAssets = statisticalInfo.getAccumulatedFortune()
                    .subtract(statisticalInfo.getCancelledFortune());
            statisticalInfo.setNetAssets(netAssets);
            customerFortuneStatisticalMap.put(statisticalInfo.getCustomerId(),statisticalInfo);
        }
        return customerFortuneStatisticalMap;
    }

    @Override
    public List<CommissionPayoutStatus> commissionPayoutStatusQuery(CommissionPayoutStatusQueryInfo requestVO) {
        return agmsFortuneMapper.commissionPayoutStatusQuery(requestVO);
    }

    @Override
    public List<FortunePayToOrderInfo> fortunePayToOrder(Long customerId, Long payId) {
        return agmsFortuneMapper.fortunePayToOrder(customerId,payId);
    }

    @Override
    public List<WithdrawLabelInfo> transformForWithdrawLabel(WithdrawQueryInfo info) {
        return agmsFortuneMapper.transformForWithdrawLabel(info);
    }
}
