package com.yd.api.agms.service;

import com.yd.api.agms.vo.fortune.*;

import java.lang.reflect.InvocationTargetException;

/**
 * @author xxy
 */
public interface AgmsFortuneService {
    /**
     * AGMS -- 修改佣金发放状态
     * @param requestVO 请求数据
     * @return 响应数据
     */
    CommissionPayoutStatusUpdateResponseVO commissionPayoutStatusUpdate(CommissionPayoutStatusUpdateRequestVO requestVO);

    /**
     * AGMS -- 修改佣金发放状态
     * @param requestVO 请求数据
     * @return 响应数据
     * @throws InvocationTargetException InvocationTargetException
     * @throws IllegalAccessException IllegalAccessException
     */
    CommissionPayoutStatusQueryResponseVO commissionPayoutStatusQuery(CommissionPayoutStatusQueryRequestVO requestVO);

    /**
     * AGMS -- 支付列表查询
     * @param requestVO 请求数据
     * @return 响应数据
     */
    WithdrawQueryResponseVO withdrawQuery(WithdrawQueryRequestVO requestVO);

    /**
     * AGMS -- 提现财富对应订单查询
     * @param requestVO 请求数据
     * @return 响应数据
     */
    FortunePayToOrderResponseVO fortunePayToOrder(FortunePayToOrderRequestVO requestVO);

    /**
     * AGMS -- 财富批量支付
     * @param requestVO 请求数据
     * @return 响应数据
     */
    FortunePayResponseVO fortunePay(FortunePayRequestVO requestVO);
}
