package com.yd.api.metadata;

import com.yd.api.metadata.service.MetadataService;
import com.yd.api.metadata.vo.TagQueryResponseVO;
import com.yd.api.result.JsonResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author xxy
 * @date 2021年06月21日 17:14
 */
@RestController
@RequestMapping("/metadata")
public class MetadataController {

    @Autowired
    public MetadataService metadataService;

    /**
     * 标签合集查询
     * @return TagQueryResponseVO
     */
    @GetMapping("/tagQuery")
    public Object tagQuery(@RequestParam(value = "isActive",required = false) Long isActive){
        JsonResult result = new JsonResult();
        TagQueryResponseVO responseVO = metadataService.tagQuery(isActive);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

}
