package com.yd.api.agms.service.impl;

import com.yd.api.agms.service.AgmsTagService;
import com.yd.api.agms.vo.tag.TagUpdateRequestVO;
import com.yd.api.agms.vo.tag.TagUpdateResponseVO;
import com.yd.api.result.CommonResult;
import com.yd.dal.entity.meta.MdTagNew;
import com.yd.dal.service.meta.MdTagNewDALService;
import com.yd.util.CommonUtil;
import com.yd.util.config.ZHBErrorConfig;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * @author xxy
 * @date 2021年06月21日 23:39
 */
@Service("AgmsTagService")
public class AgmsTagServiceImpl implements AgmsTagService {

    @Autowired
    public MdTagNewDALService mdTagNewDALService;

    @Override
    public TagUpdateResponseVO tagUpdate(TagUpdateRequestVO requestVO) {
        TagUpdateResponseVO responseVO = new TagUpdateResponseVO();
        CommonResult commonResult = new CommonResult();
        tagUpdateEntryCheck(requestVO,commonResult);
        if (!commonResult.isSuccess()){
            responseVO.setCommonResult(commonResult);
            return responseVO;
        }

        MdTagNew mdTagNew = new MdTagNew();
        BeanUtils.copyProperties(requestVO,mdTagNew);
        if (CommonUtil.isNullOrZero(requestVO.getId())){
            mdTagNew.setCreatedAt(new Date());
            mdTagNew.setUpdatedAt(new Date());
            mdTagNew.setCreatedBy(requestVO.getLoginId());
            mdTagNew.setUpdatedBy(requestVO.getLoginId());
            mdTagNewDALService.insert(mdTagNew);
        }else {
            mdTagNew.setUpdatedAt(new Date());
            mdTagNew.setUpdatedBy(requestVO.getLoginId());
            mdTagNewDALService.updateByPrimaryKeySelective(mdTagNew);
        }
        commonResult.setSuccess(true);
        commonResult.setMessage(ZHBErrorConfig.getErrorInfo("800000"));
        responseVO.setId(mdTagNew.getId());
        responseVO.setCommonResult(commonResult);
        return responseVO;
    }

    private void tagUpdateEntryCheck(TagUpdateRequestVO requestVO, CommonResult commonResult) {
        if (CommonUtil.isNullOrZero(requestVO.getConfigLevel())){
            commonResult.setSuccess(false);
            commonResult.setMessage(ZHBErrorConfig.getErrorInfo("830027"));
            return;
        }
        if (CommonUtil.isNullOrZero(requestVO.getUpperTagId()) && requestVO.getConfigLevel() != 1L){
            commonResult.setSuccess(false);
            commonResult.setMessage(ZHBErrorConfig.getErrorInfo("830028"));
            return;
        }
        commonResult.setSuccess(true);
        commonResult.setMessage(ZHBErrorConfig.getErrorInfo("800000"));
    }
}
