package com.yd.util.exception;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

import com.yd.api.result.JsonResult;
import com.yd.util.CommonUtil;

/***
 * 统一异常处理
 * @author fan
 *
 */
@ControllerAdvice
@ResponseBody
public class GlobalExceptionHandler {

 private final static Logger logger = LoggerFactory.getLogger(GlobalExceptionHandler.class); 
/**
 * 
 * @param req
 * @param ex
 * @return
 * @throws Exception
 */
 @ExceptionHandler(value=Exception.class)
public JsonResult handler(HttpServletRequest req,Exception ex) throws Exception{
	 logger.error("request url is:"+req.getRequestURL()+" \n "+CommonUtil.parseExceptionStack(ex));//ex.getMessage()
	  JsonResult result=new JsonResult();
	  result.setSuccess(false);
	  result.setMessage("system error"+ex.getMessage());
	  //TODO log
	  return result;
  }
}
