package com.yd.rmi.ali.oss.vo;

public enum OssOperateTypeEnum {
	/**
	 * 判断存储空间是否存在
	 */
	DOES_BUCKET_EXIST("doesBucketExist","判断存储空间是否存在"),
	/**
	 * 获取存储空间访问权限
	 */
	GET_BUCKET_ACL("getBucketAcl","获取存储空间访问权限"),
	/**
	 * 创建存储空间
	 */
	CREATE_BUCKET("createBucket","创建存储空间"),
	/**
	 * 列出当前访问域名下的所有存储空间
	 */
	LIST_BUCKETS("listBuckets","列出当前访问域名下的所有存储空间"),
	/**
	 * 设置存储空间访问权限
	 */
	SET_BUCKET_ACL("setBucketAcl","设置存储空间访问权限"),
	/**
	 * 判断对象是否存在
	 */
	DOES_OBJECT_EXIST("doesObjectExist","判断对象是否存在"),
	/**
	 * 获取对象的访问权限
	 */
	GET_OBJECT_ACL("getObjectAcl","获取对象的访问权限"),
	/**
	 * 上传文件
	 */
	PUT_OBJECT("putObject","上传文件"),
	/**
	 * 设置对象访问权限
	 */
	SET_OBJECT_ACL("setObjectAcl","设置对象访问权限"),
	/**
	 * 下载对象
	 */
	GET_OBJECT("getObject","下载对象"),
	/**
	 * 列出当前访问域名下的所有对象
	 */
	LIST_OBJECTS("listObjects","列出当前访问域名下的所有对象"),
	/**
	 * 获取对象外网访问URL
	 */
	GENERATE_URL("generateUrl","获取对象外网访问URL"),
	/**
	 * 删除文件
	 */
	DELETE_OBJECTS("deleteObjects","删除文件");
	
	private String code;
	private String message;
	
	public String getCode() {
		return code;
	}

	public String getMessage() {
		return message;
	}

	private OssOperateTypeEnum(String code,String message) {
		this.code=code;
		this.message=message;
	}
}
