package com.yd.dal.entity.customer;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * ag_acl_policyholder
 * @author 
 */
public class AclPolicyholder implements Serializable {
    /**
     * serial id
     */
    private Long id;

    /**
     * 规则层级 1-insurer 2-product 3-plan
     */
    private Integer configLevel;

    /**
     * 产品ID, FK ag_product.id
     */
    private Long productId;

    /**
     * 方案ID
     */
    private Long planId;

    /**
     * FK ag_acl_customer.id
     */
    private Long customerId;

    /**
     * FK ag_po_order.id
     */
    private Long orderId;

    /**
     * 单人保费
     */
    private BigDecimal policyUnitPrice;

    /**
     * 1. customer 2.policyholder 3. insured 4.partener 5.owmer 6.guardian, 7.agent
     */
    private Integer type;

    /**
     * 7.agent，多个经纪人时他们的关系，销售人员，技术支持等
     */
    private String agentRelation;

    /**
     * 是否已经只能核保过，核保结果记在status中，default:0没核过，1已经核过
     */
    private Integer hasAiConfirmed;

    /**
     * 核保結果（2:用户取消;1-正常；0-拒保）
     */
    private Integer status;

    /**
     * 有无社保（1-有；0-无）
     */
    private Integer isSocialInsured;

    private String name;

    /**
     * 英文名称
     */
    private String englishName;

    private String mobileNo;

    /**
     * email address
     */
    private String email;

    /**
     * 投保健康问卷id字符串
     */
    private String underwriteQuestionId;

    /**
     * FK ag_md_province.id 省
     */
    private Long provinceId;

    /**
     * 省名字
     */
    private String provinceName;

    /**
     * FK ag_md_district.id 县(区)
     */
    private Long districtId;

    /**
     * 县(区)名字
     */
    private String districtName;

    /**
     * FK ag_md_city.id 城市
     */
    private Long cityId;

    /**
     * 城市名字(出生地)
     */
    private String cityName;

    /**
     * FK ag_md_province.id 省（出生地）
     */
    private Long birthProvinceId;

    /**
     * 省名字(出生地)
     */
    private String birthProvinceName;

    /**
     * FK ag_md_city.id 城市（出生地）
     */
    private Long birthCityId;

    /**
     * 城市名字(出生地)
     */
    private String birthCityName;

    /**
     * FK ag_md_district.id 县(区)（出生地）
     */
    private Long birthDistrictId;

    /**
     * 县(区)名字(出生地)
     */
    private String birthDistrictName;

    /**
     * mailing address（出生地）
     */
    private String birthAddress;

    /**
     * mailing address
     */
    private String address;

    /**
     * FK ag_md_industry_occupation.id
     */
    private Long occupationId;

    /**
     * 职业名称
     */
    private String occupationName;

    /**
     * FK ag_md_id_type.id
     */
    private Long idTypeId;

    /**
     * 证件类型
     */
    private String idType;

    private String idNo;

    /**
     * 1=Male, 2=Female
     */
    private Integer gender;

    /**
     * FK ag_md_relation.id
     */
    private Long relationId;

    /**
     *  投保人被保人关系
     */
    private String relationType;

    /**
     * 0000-00-00
     */
    private Date birthDate;

    private Integer insuredSeq;

    /**
     * flag
     */
    private String flag;

    /**
     * 被保人身高
     */
    private BigDecimal insureeHeight;

    /**
     * 被保人体重
     */
    private BigDecimal insureeWeight;

    /**
     * 被保人数量(线下单)
     */
    private Integer insureeTotal;

    /**
     * 被保人证件是否长期有效? 0=No AFTER `is_social_insured` ; 1=Yes
     */
    private Integer isIdLongterm;

    /**
     * 证件有效日期 (起)
     */
    private Date idEffectiveFrom;

    /**
     * 证件有效日期 (终)
     */
    private Date idEffectiveTo;

    /**
     * FK ag_md_bank.id
     */
    private Long bankId;

    /**
     * 开户银行名= ag_md_bank.bank_name
     */
    private String bankName;

    /**
     * 持卡人名
     */
    private String bankHolder;

    private String bankNo;

    /**
     * 绑定银行卡手机号
     */
    private String bankMobileNo;

    /**
     * 创建时间
     */
    private Date createdAt;

    /**
     * 创建人
     */
    private Long createdBy;

    /**
     * 修改时间
     */
    private Date updatedAt;

    /**
     * 修改人
     */
    private Long updatedBy;

    /**
     * 身份证区域id FK ag_md_id_areamap.id
     */
    private Long idAreamapId;

    private String idAreamap;

    /**
     * 居民税收类型 1.仅为中国税收居民 2.仅为非居民 3.既是中国税收居民又是其他国家（地区）税收居民 
     */
    private Integer residentTaxType;

    /**
     * 身份证正面照片地址
     */
    private String idCardFront;

    /**
     * 身份证反面照片地址
     */
    private String idCardBack;

    /**
     * 收入来源 工资=gz  奖金或分红=jj  投资=tz  其他=其他项录入值 
     */
    private String salaryType;

    /**
     * 去年总收入 （单位：万元）
     */
    private BigDecimal salary;

    private Long bankCityId;

    /**
     * 证件备份字段
     */
    private String idNoBack;

    /**
     * 投被保人邮编
     */
    private String postCode;

    /**
     * 投被保人为单位时的联系人
     */
    private String contactName;

    /**
     * 备注，京东安联智能核保时，放保险公司返回的有疾病被保人的疾病状况
     */
    private String remark;

    private static final long serialVersionUID = 1L;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getConfigLevel() {
        return configLevel;
    }

    public void setConfigLevel(Integer configLevel) {
        this.configLevel = configLevel;
    }

    public Long getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public BigDecimal getPolicyUnitPrice() {
        return policyUnitPrice;
    }

    public void setPolicyUnitPrice(BigDecimal policyUnitPrice) {
        this.policyUnitPrice = policyUnitPrice;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getAgentRelation() {
        return agentRelation;
    }

    public void setAgentRelation(String agentRelation) {
        this.agentRelation = agentRelation;
    }

    public Integer getHasAiConfirmed() {
        return hasAiConfirmed;
    }

    public void setHasAiConfirmed(Integer hasAiConfirmed) {
        this.hasAiConfirmed = hasAiConfirmed;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getIsSocialInsured() {
        return isSocialInsured;
    }

    public void setIsSocialInsured(Integer isSocialInsured) {
        this.isSocialInsured = isSocialInsured;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEnglishName() {
        return englishName;
    }

    public void setEnglishName(String englishName) {
        this.englishName = englishName;
    }

    public String getMobileNo() {
        return mobileNo;
    }

    public void setMobileNo(String mobileNo) {
        this.mobileNo = mobileNo;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getUnderwriteQuestionId() {
        return underwriteQuestionId;
    }

    public void setUnderwriteQuestionId(String underwriteQuestionId) {
        this.underwriteQuestionId = underwriteQuestionId;
    }

    public Long getProvinceId() {
        return provinceId;
    }

    public void setProvinceId(Long provinceId) {
        this.provinceId = provinceId;
    }

    public String getProvinceName() {
        return provinceName;
    }

    public void setProvinceName(String provinceName) {
        this.provinceName = provinceName;
    }

    public Long getDistrictId() {
        return districtId;
    }

    public void setDistrictId(Long districtId) {
        this.districtId = districtId;
    }

    public String getDistrictName() {
        return districtName;
    }

    public void setDistrictName(String districtName) {
        this.districtName = districtName;
    }

    public Long getCityId() {
        return cityId;
    }

    public void setCityId(Long cityId) {
        this.cityId = cityId;
    }

    public String getCityName() {
        return cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public Long getBirthProvinceId() {
        return birthProvinceId;
    }

    public void setBirthProvinceId(Long birthProvinceId) {
        this.birthProvinceId = birthProvinceId;
    }

    public String getBirthProvinceName() {
        return birthProvinceName;
    }

    public void setBirthProvinceName(String birthProvinceName) {
        this.birthProvinceName = birthProvinceName;
    }

    public Long getBirthCityId() {
        return birthCityId;
    }

    public void setBirthCityId(Long birthCityId) {
        this.birthCityId = birthCityId;
    }

    public String getBirthCityName() {
        return birthCityName;
    }

    public void setBirthCityName(String birthCityName) {
        this.birthCityName = birthCityName;
    }

    public Long getBirthDistrictId() {
        return birthDistrictId;
    }

    public void setBirthDistrictId(Long birthDistrictId) {
        this.birthDistrictId = birthDistrictId;
    }

    public String getBirthDistrictName() {
        return birthDistrictName;
    }

    public void setBirthDistrictName(String birthDistrictName) {
        this.birthDistrictName = birthDistrictName;
    }

    public String getBirthAddress() {
        return birthAddress;
    }

    public void setBirthAddress(String birthAddress) {
        this.birthAddress = birthAddress;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Long getOccupationId() {
        return occupationId;
    }

    public void setOccupationId(Long occupationId) {
        this.occupationId = occupationId;
    }

    public String getOccupationName() {
        return occupationName;
    }

    public void setOccupationName(String occupationName) {
        this.occupationName = occupationName;
    }

    public Long getIdTypeId() {
        return idTypeId;
    }

    public void setIdTypeId(Long idTypeId) {
        this.idTypeId = idTypeId;
    }

    public String getIdType() {
        return idType;
    }

    public void setIdType(String idType) {
        this.idType = idType;
    }

    public String getIdNo() {
        return idNo;
    }

    public void setIdNo(String idNo) {
        this.idNo = idNo;
    }

    public Integer getGender() {
        return gender;
    }

    public void setGender(Integer gender) {
        this.gender = gender;
    }

    public Long getRelationId() {
        return relationId;
    }

    public void setRelationId(Long relationId) {
        this.relationId = relationId;
    }

    public String getRelationType() {
        return relationType;
    }

    public void setRelationType(String relationType) {
        this.relationType = relationType;
    }

    public Date getBirthDate() {
        return birthDate;
    }

    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }

    public Integer getInsuredSeq() {
        return insuredSeq;
    }

    public void setInsuredSeq(Integer insuredSeq) {
        this.insuredSeq = insuredSeq;
    }

    public String getFlag() {
        return flag;
    }

    public void setFlag(String flag) {
        this.flag = flag;
    }

    public BigDecimal getInsureeHeight() {
        return insureeHeight;
    }

    public void setInsureeHeight(BigDecimal insureeHeight) {
        this.insureeHeight = insureeHeight;
    }

    public BigDecimal getInsureeWeight() {
        return insureeWeight;
    }

    public void setInsureeWeight(BigDecimal insureeWeight) {
        this.insureeWeight = insureeWeight;
    }

    public Integer getInsureeTotal() {
        return insureeTotal;
    }

    public void setInsureeTotal(Integer insureeTotal) {
        this.insureeTotal = insureeTotal;
    }

    public Integer getIsIdLongterm() {
        return isIdLongterm;
    }

    public void setIsIdLongterm(Integer isIdLongterm) {
        this.isIdLongterm = isIdLongterm;
    }

    public Date getIdEffectiveFrom() {
        return idEffectiveFrom;
    }

    public void setIdEffectiveFrom(Date idEffectiveFrom) {
        this.idEffectiveFrom = idEffectiveFrom;
    }

    public Date getIdEffectiveTo() {
        return idEffectiveTo;
    }

    public void setIdEffectiveTo(Date idEffectiveTo) {
        this.idEffectiveTo = idEffectiveTo;
    }

    public Long getBankId() {
        return bankId;
    }

    public void setBankId(Long bankId) {
        this.bankId = bankId;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getBankHolder() {
        return bankHolder;
    }

    public void setBankHolder(String bankHolder) {
        this.bankHolder = bankHolder;
    }

    public String getBankNo() {
        return bankNo;
    }

    public void setBankNo(String bankNo) {
        this.bankNo = bankNo;
    }

    public String getBankMobileNo() {
        return bankMobileNo;
    }

    public void setBankMobileNo(String bankMobileNo) {
        this.bankMobileNo = bankMobileNo;
    }

    public Date getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Long getCreatedBy() {
        return createdBy;
    }

    public void setCreatedBy(Long createdBy) {
        this.createdBy = createdBy;
    }

    public Date getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Long getUpdatedBy() {
        return updatedBy;
    }

    public void setUpdatedBy(Long updatedBy) {
        this.updatedBy = updatedBy;
    }

    public Long getIdAreamapId() {
        return idAreamapId;
    }

    public void setIdAreamapId(Long idAreamapId) {
        this.idAreamapId = idAreamapId;
    }

    public String getIdAreamap() {
        return idAreamap;
    }

    public void setIdAreamap(String idAreamap) {
        this.idAreamap = idAreamap;
    }

    public Integer getResidentTaxType() {
        return residentTaxType;
    }

    public void setResidentTaxType(Integer residentTaxType) {
        this.residentTaxType = residentTaxType;
    }

    public String getIdCardFront() {
        return idCardFront;
    }

    public void setIdCardFront(String idCardFront) {
        this.idCardFront = idCardFront;
    }

    public String getIdCardBack() {
        return idCardBack;
    }

    public void setIdCardBack(String idCardBack) {
        this.idCardBack = idCardBack;
    }

    public String getSalaryType() {
        return salaryType;
    }

    public void setSalaryType(String salaryType) {
        this.salaryType = salaryType;
    }

    public BigDecimal getSalary() {
        return salary;
    }

    public void setSalary(BigDecimal salary) {
        this.salary = salary;
    }

    public Long getBankCityId() {
        return bankCityId;
    }

    public void setBankCityId(Long bankCityId) {
        this.bankCityId = bankCityId;
    }

    public String getIdNoBack() {
        return idNoBack;
    }

    public void setIdNoBack(String idNoBack) {
        this.idNoBack = idNoBack;
    }

    public String getPostCode() {
        return postCode;
    }

    public void setPostCode(String postCode) {
        this.postCode = postCode;
    }

    public String getContactName() {
        return contactName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        AclPolicyholder other = (AclPolicyholder) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getConfigLevel() == null ? other.getConfigLevel() == null : this.getConfigLevel().equals(other.getConfigLevel()))
            && (this.getProductId() == null ? other.getProductId() == null : this.getProductId().equals(other.getProductId()))
            && (this.getPlanId() == null ? other.getPlanId() == null : this.getPlanId().equals(other.getPlanId()))
            && (this.getCustomerId() == null ? other.getCustomerId() == null : this.getCustomerId().equals(other.getCustomerId()))
            && (this.getOrderId() == null ? other.getOrderId() == null : this.getOrderId().equals(other.getOrderId()))
            && (this.getPolicyUnitPrice() == null ? other.getPolicyUnitPrice() == null : this.getPolicyUnitPrice().equals(other.getPolicyUnitPrice()))
            && (this.getType() == null ? other.getType() == null : this.getType().equals(other.getType()))
            && (this.getAgentRelation() == null ? other.getAgentRelation() == null : this.getAgentRelation().equals(other.getAgentRelation()))
            && (this.getHasAiConfirmed() == null ? other.getHasAiConfirmed() == null : this.getHasAiConfirmed().equals(other.getHasAiConfirmed()))
            && (this.getStatus() == null ? other.getStatus() == null : this.getStatus().equals(other.getStatus()))
            && (this.getIsSocialInsured() == null ? other.getIsSocialInsured() == null : this.getIsSocialInsured().equals(other.getIsSocialInsured()))
            && (this.getName() == null ? other.getName() == null : this.getName().equals(other.getName()))
            && (this.getEnglishName() == null ? other.getEnglishName() == null : this.getEnglishName().equals(other.getEnglishName()))
            && (this.getMobileNo() == null ? other.getMobileNo() == null : this.getMobileNo().equals(other.getMobileNo()))
            && (this.getEmail() == null ? other.getEmail() == null : this.getEmail().equals(other.getEmail()))
            && (this.getUnderwriteQuestionId() == null ? other.getUnderwriteQuestionId() == null : this.getUnderwriteQuestionId().equals(other.getUnderwriteQuestionId()))
            && (this.getProvinceId() == null ? other.getProvinceId() == null : this.getProvinceId().equals(other.getProvinceId()))
            && (this.getProvinceName() == null ? other.getProvinceName() == null : this.getProvinceName().equals(other.getProvinceName()))
            && (this.getDistrictId() == null ? other.getDistrictId() == null : this.getDistrictId().equals(other.getDistrictId()))
            && (this.getDistrictName() == null ? other.getDistrictName() == null : this.getDistrictName().equals(other.getDistrictName()))
            && (this.getCityId() == null ? other.getCityId() == null : this.getCityId().equals(other.getCityId()))
            && (this.getCityName() == null ? other.getCityName() == null : this.getCityName().equals(other.getCityName()))
            && (this.getBirthProvinceId() == null ? other.getBirthProvinceId() == null : this.getBirthProvinceId().equals(other.getBirthProvinceId()))
            && (this.getBirthProvinceName() == null ? other.getBirthProvinceName() == null : this.getBirthProvinceName().equals(other.getBirthProvinceName()))
            && (this.getBirthCityId() == null ? other.getBirthCityId() == null : this.getBirthCityId().equals(other.getBirthCityId()))
            && (this.getBirthCityName() == null ? other.getBirthCityName() == null : this.getBirthCityName().equals(other.getBirthCityName()))
            && (this.getBirthDistrictId() == null ? other.getBirthDistrictId() == null : this.getBirthDistrictId().equals(other.getBirthDistrictId()))
            && (this.getBirthDistrictName() == null ? other.getBirthDistrictName() == null : this.getBirthDistrictName().equals(other.getBirthDistrictName()))
            && (this.getBirthAddress() == null ? other.getBirthAddress() == null : this.getBirthAddress().equals(other.getBirthAddress()))
            && (this.getAddress() == null ? other.getAddress() == null : this.getAddress().equals(other.getAddress()))
            && (this.getOccupationId() == null ? other.getOccupationId() == null : this.getOccupationId().equals(other.getOccupationId()))
            && (this.getOccupationName() == null ? other.getOccupationName() == null : this.getOccupationName().equals(other.getOccupationName()))
            && (this.getIdTypeId() == null ? other.getIdTypeId() == null : this.getIdTypeId().equals(other.getIdTypeId()))
            && (this.getIdType() == null ? other.getIdType() == null : this.getIdType().equals(other.getIdType()))
            && (this.getIdNo() == null ? other.getIdNo() == null : this.getIdNo().equals(other.getIdNo()))
            && (this.getGender() == null ? other.getGender() == null : this.getGender().equals(other.getGender()))
            && (this.getRelationId() == null ? other.getRelationId() == null : this.getRelationId().equals(other.getRelationId()))
            && (this.getRelationType() == null ? other.getRelationType() == null : this.getRelationType().equals(other.getRelationType()))
            && (this.getBirthDate() == null ? other.getBirthDate() == null : this.getBirthDate().equals(other.getBirthDate()))
            && (this.getInsuredSeq() == null ? other.getInsuredSeq() == null : this.getInsuredSeq().equals(other.getInsuredSeq()))
            && (this.getFlag() == null ? other.getFlag() == null : this.getFlag().equals(other.getFlag()))
            && (this.getInsureeHeight() == null ? other.getInsureeHeight() == null : this.getInsureeHeight().equals(other.getInsureeHeight()))
            && (this.getInsureeWeight() == null ? other.getInsureeWeight() == null : this.getInsureeWeight().equals(other.getInsureeWeight()))
            && (this.getInsureeTotal() == null ? other.getInsureeTotal() == null : this.getInsureeTotal().equals(other.getInsureeTotal()))
            && (this.getIsIdLongterm() == null ? other.getIsIdLongterm() == null : this.getIsIdLongterm().equals(other.getIsIdLongterm()))
            && (this.getIdEffectiveFrom() == null ? other.getIdEffectiveFrom() == null : this.getIdEffectiveFrom().equals(other.getIdEffectiveFrom()))
            && (this.getIdEffectiveTo() == null ? other.getIdEffectiveTo() == null : this.getIdEffectiveTo().equals(other.getIdEffectiveTo()))
            && (this.getBankId() == null ? other.getBankId() == null : this.getBankId().equals(other.getBankId()))
            && (this.getBankName() == null ? other.getBankName() == null : this.getBankName().equals(other.getBankName()))
            && (this.getBankHolder() == null ? other.getBankHolder() == null : this.getBankHolder().equals(other.getBankHolder()))
            && (this.getBankNo() == null ? other.getBankNo() == null : this.getBankNo().equals(other.getBankNo()))
            && (this.getBankMobileNo() == null ? other.getBankMobileNo() == null : this.getBankMobileNo().equals(other.getBankMobileNo()))
            && (this.getCreatedAt() == null ? other.getCreatedAt() == null : this.getCreatedAt().equals(other.getCreatedAt()))
            && (this.getCreatedBy() == null ? other.getCreatedBy() == null : this.getCreatedBy().equals(other.getCreatedBy()))
            && (this.getUpdatedAt() == null ? other.getUpdatedAt() == null : this.getUpdatedAt().equals(other.getUpdatedAt()))
            && (this.getUpdatedBy() == null ? other.getUpdatedBy() == null : this.getUpdatedBy().equals(other.getUpdatedBy()))
            && (this.getIdAreamapId() == null ? other.getIdAreamapId() == null : this.getIdAreamapId().equals(other.getIdAreamapId()))
            && (this.getIdAreamap() == null ? other.getIdAreamap() == null : this.getIdAreamap().equals(other.getIdAreamap()))
            && (this.getResidentTaxType() == null ? other.getResidentTaxType() == null : this.getResidentTaxType().equals(other.getResidentTaxType()))
            && (this.getIdCardFront() == null ? other.getIdCardFront() == null : this.getIdCardFront().equals(other.getIdCardFront()))
            && (this.getIdCardBack() == null ? other.getIdCardBack() == null : this.getIdCardBack().equals(other.getIdCardBack()))
            && (this.getSalaryType() == null ? other.getSalaryType() == null : this.getSalaryType().equals(other.getSalaryType()))
            && (this.getSalary() == null ? other.getSalary() == null : this.getSalary().equals(other.getSalary()))
            && (this.getBankCityId() == null ? other.getBankCityId() == null : this.getBankCityId().equals(other.getBankCityId()))
            && (this.getIdNoBack() == null ? other.getIdNoBack() == null : this.getIdNoBack().equals(other.getIdNoBack()))
            && (this.getPostCode() == null ? other.getPostCode() == null : this.getPostCode().equals(other.getPostCode()))
            && (this.getContactName() == null ? other.getContactName() == null : this.getContactName().equals(other.getContactName()))
            && (this.getRemark() == null ? other.getRemark() == null : this.getRemark().equals(other.getRemark()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getConfigLevel() == null) ? 0 : getConfigLevel().hashCode());
        result = prime * result + ((getProductId() == null) ? 0 : getProductId().hashCode());
        result = prime * result + ((getPlanId() == null) ? 0 : getPlanId().hashCode());
        result = prime * result + ((getCustomerId() == null) ? 0 : getCustomerId().hashCode());
        result = prime * result + ((getOrderId() == null) ? 0 : getOrderId().hashCode());
        result = prime * result + ((getPolicyUnitPrice() == null) ? 0 : getPolicyUnitPrice().hashCode());
        result = prime * result + ((getType() == null) ? 0 : getType().hashCode());
        result = prime * result + ((getAgentRelation() == null) ? 0 : getAgentRelation().hashCode());
        result = prime * result + ((getHasAiConfirmed() == null) ? 0 : getHasAiConfirmed().hashCode());
        result = prime * result + ((getStatus() == null) ? 0 : getStatus().hashCode());
        result = prime * result + ((getIsSocialInsured() == null) ? 0 : getIsSocialInsured().hashCode());
        result = prime * result + ((getName() == null) ? 0 : getName().hashCode());
        result = prime * result + ((getEnglishName() == null) ? 0 : getEnglishName().hashCode());
        result = prime * result + ((getMobileNo() == null) ? 0 : getMobileNo().hashCode());
        result = prime * result + ((getEmail() == null) ? 0 : getEmail().hashCode());
        result = prime * result + ((getUnderwriteQuestionId() == null) ? 0 : getUnderwriteQuestionId().hashCode());
        result = prime * result + ((getProvinceId() == null) ? 0 : getProvinceId().hashCode());
        result = prime * result + ((getProvinceName() == null) ? 0 : getProvinceName().hashCode());
        result = prime * result + ((getDistrictId() == null) ? 0 : getDistrictId().hashCode());
        result = prime * result + ((getDistrictName() == null) ? 0 : getDistrictName().hashCode());
        result = prime * result + ((getCityId() == null) ? 0 : getCityId().hashCode());
        result = prime * result + ((getCityName() == null) ? 0 : getCityName().hashCode());
        result = prime * result + ((getBirthProvinceId() == null) ? 0 : getBirthProvinceId().hashCode());
        result = prime * result + ((getBirthProvinceName() == null) ? 0 : getBirthProvinceName().hashCode());
        result = prime * result + ((getBirthCityId() == null) ? 0 : getBirthCityId().hashCode());
        result = prime * result + ((getBirthCityName() == null) ? 0 : getBirthCityName().hashCode());
        result = prime * result + ((getBirthDistrictId() == null) ? 0 : getBirthDistrictId().hashCode());
        result = prime * result + ((getBirthDistrictName() == null) ? 0 : getBirthDistrictName().hashCode());
        result = prime * result + ((getBirthAddress() == null) ? 0 : getBirthAddress().hashCode());
        result = prime * result + ((getAddress() == null) ? 0 : getAddress().hashCode());
        result = prime * result + ((getOccupationId() == null) ? 0 : getOccupationId().hashCode());
        result = prime * result + ((getOccupationName() == null) ? 0 : getOccupationName().hashCode());
        result = prime * result + ((getIdTypeId() == null) ? 0 : getIdTypeId().hashCode());
        result = prime * result + ((getIdType() == null) ? 0 : getIdType().hashCode());
        result = prime * result + ((getIdNo() == null) ? 0 : getIdNo().hashCode());
        result = prime * result + ((getGender() == null) ? 0 : getGender().hashCode());
        result = prime * result + ((getRelationId() == null) ? 0 : getRelationId().hashCode());
        result = prime * result + ((getRelationType() == null) ? 0 : getRelationType().hashCode());
        result = prime * result + ((getBirthDate() == null) ? 0 : getBirthDate().hashCode());
        result = prime * result + ((getInsuredSeq() == null) ? 0 : getInsuredSeq().hashCode());
        result = prime * result + ((getFlag() == null) ? 0 : getFlag().hashCode());
        result = prime * result + ((getInsureeHeight() == null) ? 0 : getInsureeHeight().hashCode());
        result = prime * result + ((getInsureeWeight() == null) ? 0 : getInsureeWeight().hashCode());
        result = prime * result + ((getInsureeTotal() == null) ? 0 : getInsureeTotal().hashCode());
        result = prime * result + ((getIsIdLongterm() == null) ? 0 : getIsIdLongterm().hashCode());
        result = prime * result + ((getIdEffectiveFrom() == null) ? 0 : getIdEffectiveFrom().hashCode());
        result = prime * result + ((getIdEffectiveTo() == null) ? 0 : getIdEffectiveTo().hashCode());
        result = prime * result + ((getBankId() == null) ? 0 : getBankId().hashCode());
        result = prime * result + ((getBankName() == null) ? 0 : getBankName().hashCode());
        result = prime * result + ((getBankHolder() == null) ? 0 : getBankHolder().hashCode());
        result = prime * result + ((getBankNo() == null) ? 0 : getBankNo().hashCode());
        result = prime * result + ((getBankMobileNo() == null) ? 0 : getBankMobileNo().hashCode());
        result = prime * result + ((getCreatedAt() == null) ? 0 : getCreatedAt().hashCode());
        result = prime * result + ((getCreatedBy() == null) ? 0 : getCreatedBy().hashCode());
        result = prime * result + ((getUpdatedAt() == null) ? 0 : getUpdatedAt().hashCode());
        result = prime * result + ((getUpdatedBy() == null) ? 0 : getUpdatedBy().hashCode());
        result = prime * result + ((getIdAreamapId() == null) ? 0 : getIdAreamapId().hashCode());
        result = prime * result + ((getIdAreamap() == null) ? 0 : getIdAreamap().hashCode());
        result = prime * result + ((getResidentTaxType() == null) ? 0 : getResidentTaxType().hashCode());
        result = prime * result + ((getIdCardFront() == null) ? 0 : getIdCardFront().hashCode());
        result = prime * result + ((getIdCardBack() == null) ? 0 : getIdCardBack().hashCode());
        result = prime * result + ((getSalaryType() == null) ? 0 : getSalaryType().hashCode());
        result = prime * result + ((getSalary() == null) ? 0 : getSalary().hashCode());
        result = prime * result + ((getBankCityId() == null) ? 0 : getBankCityId().hashCode());
        result = prime * result + ((getIdNoBack() == null) ? 0 : getIdNoBack().hashCode());
        result = prime * result + ((getPostCode() == null) ? 0 : getPostCode().hashCode());
        result = prime * result + ((getContactName() == null) ? 0 : getContactName().hashCode());
        result = prime * result + ((getRemark() == null) ? 0 : getRemark().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", id=").append(id);
        sb.append(", configLevel=").append(configLevel);
        sb.append(", productId=").append(productId);
        sb.append(", planId=").append(planId);
        sb.append(", customerId=").append(customerId);
        sb.append(", orderId=").append(orderId);
        sb.append(", policyUnitPrice=").append(policyUnitPrice);
        sb.append(", type=").append(type);
        sb.append(", agentRelation=").append(agentRelation);
        sb.append(", hasAiConfirmed=").append(hasAiConfirmed);
        sb.append(", status=").append(status);
        sb.append(", isSocialInsured=").append(isSocialInsured);
        sb.append(", name=").append(name);
        sb.append(", englishName=").append(englishName);
        sb.append(", mobileNo=").append(mobileNo);
        sb.append(", email=").append(email);
        sb.append(", underwriteQuestionId=").append(underwriteQuestionId);
        sb.append(", provinceId=").append(provinceId);
        sb.append(", provinceName=").append(provinceName);
        sb.append(", districtId=").append(districtId);
        sb.append(", districtName=").append(districtName);
        sb.append(", cityId=").append(cityId);
        sb.append(", cityName=").append(cityName);
        sb.append(", birthProvinceId=").append(birthProvinceId);
        sb.append(", birthProvinceName=").append(birthProvinceName);
        sb.append(", birthCityId=").append(birthCityId);
        sb.append(", birthCityName=").append(birthCityName);
        sb.append(", birthDistrictId=").append(birthDistrictId);
        sb.append(", birthDistrictName=").append(birthDistrictName);
        sb.append(", birthAddress=").append(birthAddress);
        sb.append(", address=").append(address);
        sb.append(", occupationId=").append(occupationId);
        sb.append(", occupationName=").append(occupationName);
        sb.append(", idTypeId=").append(idTypeId);
        sb.append(", idType=").append(idType);
        sb.append(", idNo=").append(idNo);
        sb.append(", gender=").append(gender);
        sb.append(", relationId=").append(relationId);
        sb.append(", relationType=").append(relationType);
        sb.append(", birthDate=").append(birthDate);
        sb.append(", insuredSeq=").append(insuredSeq);
        sb.append(", flag=").append(flag);
        sb.append(", insureeHeight=").append(insureeHeight);
        sb.append(", insureeWeight=").append(insureeWeight);
        sb.append(", insureeTotal=").append(insureeTotal);
        sb.append(", isIdLongterm=").append(isIdLongterm);
        sb.append(", idEffectiveFrom=").append(idEffectiveFrom);
        sb.append(", idEffectiveTo=").append(idEffectiveTo);
        sb.append(", bankId=").append(bankId);
        sb.append(", bankName=").append(bankName);
        sb.append(", bankHolder=").append(bankHolder);
        sb.append(", bankNo=").append(bankNo);
        sb.append(", bankMobileNo=").append(bankMobileNo);
        sb.append(", createdAt=").append(createdAt);
        sb.append(", createdBy=").append(createdBy);
        sb.append(", updatedAt=").append(updatedAt);
        sb.append(", updatedBy=").append(updatedBy);
        sb.append(", idAreamapId=").append(idAreamapId);
        sb.append(", idAreamap=").append(idAreamap);
        sb.append(", residentTaxType=").append(residentTaxType);
        sb.append(", idCardFront=").append(idCardFront);
        sb.append(", idCardBack=").append(idCardBack);
        sb.append(", salaryType=").append(salaryType);
        sb.append(", salary=").append(salary);
        sb.append(", bankCityId=").append(bankCityId);
        sb.append(", idNoBack=").append(idNoBack);
        sb.append(", postCode=").append(postCode);
        sb.append(", contactName=").append(contactName);
        sb.append(", remark=").append(remark);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}