package com.yd.api.practitioner.service.impl;

import com.yd.api.practitioner.service.PractitionerHiringContractService;
import com.yd.dal.entity.practitioner.hiring.HiringBasicInfo;
import com.yd.dal.entity.practitioner.hiring.HiringMemberShip;
import com.yd.dal.entity.practitioner.hiring.HiringPersonalStatements;
import com.yd.dal.entity.practitioner.hiring.HiringWorkingExperience;
import com.yd.dal.mapper.customer.AclPractitionerHiringBasicInfoMapper;
import com.yd.dal.mapper.customer.AclPractitionerHiringMembershipMapper;
import com.yd.dal.mapper.customer.AclPractitionerHiringPersonalStatementsMapper;
import com.yd.dal.mapper.customer.AclPractitionerHiringWorkingExperienceMapper;
import com.yd.dal.mapper.practitioner.PractitionerHiringMapper;
import com.libs.pdf.*;
import com.yd.rmi.ali.oss.service.OssService;
import com.yd.util.CommonUtil;
import com.yd.util.PDFConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("PractitionerHiringContractService")
public class PractitionerHiringContractServiceImpl implements PractitionerHiringContractService {
    @Autowired
    private OssService ossService;
    @Resource
    private PractitionerHiringMapper practitionerHiringMapper;

    /**
     *  申请经纪人的ID，生成电子合同，在经纪人表中自动生成记录
     * @param hiringBasicInfoId
     * @return
     */
    @Override
    public String generatePractitionerContract(Long hiringBasicInfoId) {
        //1、从DB中按照hiringBasicInfoId，获取经纪人的文字信息
        Map<String, String> initDatas = new HashMap<String, String>();
        initDatas = initHiringBasicInfoData(hiringBasicInfoId);

        //2、从DB中按照hiringBasicInfoId，从oss上获取经纪人上传的图片信息，需存本地临时文件
        Map<String, String> initImages = new HashMap<String, String>();
        initImages = initHiringImageInfoData(hiringBasicInfoId);

        //ag_acl_practitioner.employee_no
        String practitionerNO = "YDSH00009";
        String contractNO = "CTSH00009";

        //3、PDF模板生成合同文件，存本地临时文件后，上传oss
        String contractFile = generatePractitionerPDF(practitionerNO,initDatas,initImages);

        //上传至oss    ossService
        String contractFileOSS = contractFile;

        //4、经纪人表生成经纪人记录ag_acl_practitioner，ag_acl_practitioner.contract_oss_path
        //   经纪人经纪人类型级别定义表ag_acl_practitioner_setting
        return contractFileOSS;
    }

    /**
     *  申请ID的数据列表
     * @param hiringBasicInfoId
     * @return
     */
    @Override
    public Map<String, String> initHiringBasicInfoData(Long hiringBasicInfoId) {
        //PDF模板中定义的文字key，和值的集合
        Map<String, String> data = new HashMap<String, String>();
        HiringBasicInfo hiringBasicInfo = practitionerHiringMapper.findHiringBasicInfo(hiringBasicInfoId);
        //模板文件生成零时文件
        //甲方
        String firstParty = PDFConfiguration.getProperty("pdf.firstParty");
        //甲方负责人
        String firstPartyResponser = PDFConfiguration.getProperty("pdf.firstPartyResponser");
        //甲方地址
        String firstPartyAddress = PDFConfiguration.getProperty("pdf.firstPartyAddress");

        return data;
    }

    /**
     *  申请ID的图片列表，本地地址。从oss上拉到本地
     * @param hiringBasicInfoId
     * @return
     */
    @Override
    public Map<String, String> initHiringImageInfoData(Long hiringBasicInfoId) {
        //PDF模板中定义的文字key，和值的集合
        Map<String, String> images = new HashMap<String, String>();
        //选中
        String check = PDFConfiguration.getProperty("pdf.check");
        //未选中
        String uncheck = PDFConfiguration.getProperty("pdf.uncheck");

        return images;
    }

    /**
     *  用采集过来的经纪人数据、图片，生成该经纪人的电子合同
     * @param initDatas
     * @param initImages
     * @return
     */
    @Override
    public String generatePractitionerPDF(String practitionerNO,Map<String, String> initDatas,Map<String, String> initImages) {
        String templatePDF = "D:\\pcs12\\templatePractitionerContract.pdf";
        templatePDF = PDFConfiguration.getProperty("pdf.template");
        //模板文件生成零时文件
        String tmpPathPDF = PDFConfiguration.getProperty("pdf.temp.path");

        //PDF模板输出结果文件
        String templateResultPDF = tmpPathPDF + practitionerNO + "-template.pdf";
        //按模板填充数据生成结果PDF
        PDFTemplate.generatePDF(templatePDF,templateResultPDF,initDatas,initImages);

        //加盖电子印章结果文件
        String signResultPDF = "D:\\pcs12\\signedYD.pdf";
        signResultPDF = tmpPathPDF + practitionerNO + "-signedYD.pdf";

        String password="UC645YlB";
        password = CommonUtil.readFileTxt(PDFConfiguration.getProperty("pdf.keyPasswordFile"));

        String keyStorePath="D:\\pcs12\\4929078_m.zuihuibi.cn.pfx";
        keyStorePath = PDFConfiguration.getProperty("pdf.keyStorePath");;

        //准备加盖电子印章的源文件
        String signSourcePDF = templateResultPDF;
        //电子印章文件
        String signImage="D:\\pcs12\\上海银盾保险经纪有限公司.png";
        signImage = PDFConfiguration.getProperty("pdf.signImage");
        float x = 450;
        float y = 150;
        x = Float.parseFloat(PDFConfiguration.getProperty("pdf.position.x"));
        y = Float.parseFloat(PDFConfiguration.getProperty("pdf.position.y"));
        try {
            PDFSign.sign(signResultPDF,password,keyStorePath,signSourcePDF,signImage,x,y);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return signResultPDF;
    }
}
