package com.yd.dal.service.customer.impl;

import com.yd.api.practitioner.vo.rank.AclCustomerFortuneStatistics;
import com.yd.dal.entity.customer.AclCustomerFortune;
import com.yd.dal.mapper.customer.AclCustomerFortuneMapper;
import com.yd.dal.service.customer.AclCustomerFortuneDALService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service("aclCustomerFortuneDALService")
public class AclCustomerFortuneDALServiceImpl implements AclCustomerFortuneDALService {
    @Resource
    private AclCustomerFortuneMapper aclCustomerFortuneMapper;
    @Override
    public List<AclCustomerFortuneStatistics> findBySubordinateSystemStatistics(Long subordinateSystemId, Integer time) {
        return aclCustomerFortuneMapper.findBySubordinateSystemStatistics(subordinateSystemId,time);
    }

    @Override
    public List<AclCustomerFortune> findByIds(Long[] fortuneIds) {
        return aclCustomerFortuneMapper.findByIds(fortuneIds);
    }

    @Override
    public void updateBatch(List<AclCustomerFortune> fortuneUpdates) {
        if (!fortuneUpdates.isEmpty()){
            aclCustomerFortuneMapper.updateBatch(fortuneUpdates);
        }
    }
}
