package com.yd.api.agms.service.impl;

import com.yd.api.agms.service.AgmsFortuneService;
import com.yd.api.agms.vo.fortune.CommissionPayoutStatusUpdateRequestVO;
import com.yd.api.agms.vo.fortune.CommissionPayoutStatusUpdateResponseVO;
import com.yd.api.result.CommonResult;
import com.yd.dal.entity.customer.AclCustomerFortune;
import com.yd.dal.entity.customer.AclCustomerFortuneWithdraw;
import com.yd.dal.service.customer.AclCustomerFortuneDALService;
import com.yd.dal.service.customer.AclCustomerFortuneWithdrawDALService;
import com.yd.util.CommonUtil;
import com.yd.util.config.ZHBErrorConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.lang.reflect.Method;
import java.security.acl.Acl;
import java.util.*;

/**
 * @author xxy
 */
@Service("agmsFortuneService")
public class AgmsFortuneServiceImpl implements AgmsFortuneService {

    private AclCustomerFortuneDALService customerFortuneDalService;
    private AclCustomerFortuneWithdrawDALService customerFortuneWithdrawDalService;

    @Autowired
    public void setAclCustomerFortuneDalService(AclCustomerFortuneDALService customerFortuneDalService) {
        this.customerFortuneDalService = customerFortuneDalService;
    }
    @Autowired
    public void setAclCustomerFortuneWithdrawDalService(AclCustomerFortuneWithdrawDALService customerFortuneWithdrawDalService) {
        this.customerFortuneWithdrawDalService = customerFortuneWithdrawDalService;
    }


    @Override
    public CommissionPayoutStatusUpdateResponseVO commissionPayoutStatusUpdate(CommissionPayoutStatusUpdateRequestVO requestVO) {
        CommissionPayoutStatusUpdateResponseVO responseVO = new CommissionPayoutStatusUpdateResponseVO();
        Long[] fortuneIds = requestVO.getFortuneIds();
        //1.暂不可发  2.可发放  3.保留
        String paymentStatus = requestVO.getPaymentStatus();
        Long loginId = requestVO.getLoginId();
        //查询出需修改的佣金发放状态的财富
        List<AclCustomerFortune> customerFortunes = customerFortuneDalService.findByIds(fortuneIds);

        if (("2").equals(paymentStatus)){
            //如paymentStatus = 2(可发放),只需统计Fortune对应Customer最后一笔未支付的Withdraw,重新计算,如没有Withdraw生成一条新的Withdraw记录
            canPaymentUpDate(paymentStatus,loginId,customerFortunes);
        }else {
            //如paymentStatus != 2(暂不可发,保留),只需统计原Fortune对应的Withdraw,重新计算
            noPaymentUpDate(paymentStatus,loginId,customerFortunes);
        }

        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    private void canPaymentUpDate(String paymentStatus, Long loginId, List<AclCustomerFortune> customerFortunes) {
        //将查询出来的财富列表根据customerId经行分类
        Map<Long,List<AclCustomerFortune>> customerFortuneMap = changeCustomerFortunes(customerFortunes);
        //获得所有需要修改佣金发放状的customerIds
        Set<Long> customerIds = customerFortuneMap.keySet();
        //查询这些customerId最后一笔未完成的提现记录ag_acl_customer_fortune_withdraw,需重新计算withdraw
        Map<Long,Long> customerWithdrawMap = customerFortuneWithdrawDalService.findFinalWithdrawNoPayByCustomerIds(customerIds);
        //没有最后一笔提现记录客户信息和此次提现的财富记录  customerId  fortunes
        Map<Long,List<AclCustomerFortune>> newCustomerWithdrawMap = new HashMap<>(16);
        //可直接修改的fortune记录(需修改佣金发放状态)
        List<AclCustomerFortune> fortuneUpdates = new ArrayList<>();

        for(Map.Entry<Long, List<AclCustomerFortune>> customerFortune:customerFortuneMap.entrySet()){
            //获取需要修改佣金发放状态的经纪人
            Long customerId = customerFortune.getKey();
            //此customer最后一笔提现记录id
            Long withdrawId = customerWithdrawMap.get(customerId);
            //新提现的记录
            List<AclCustomerFortune> newFortunes = new ArrayList<>();
            //获取休要修改的佣金发放状态的财富记录
            List<AclCustomerFortune> fortunes = customerFortune.getValue();
            //判断这些财富记录中佣金发放状态和要修改的状态是否一致,如一致,则不需要修改
            for(AclCustomerFortune fortune : customerFortunes) {
                //不一致,进行修改,并保存需修改的fortune和记录需要新生成的fortune
                if (!paymentStatus.equals(fortune.getCommissionPayoutStatus())) {
                    fortune.setCommissionPayoutStatus(paymentStatus);
                    fortune.setCommissionPayoutBy(loginId);
                    fortune.setCommissionPayoutAt(new Date());
                    if (CommonUtil.isNullOrZero(withdrawId)){
                        //需生成新的withdraw
                        newFortunes.add(fortune);
                    }else {
                        //可直接修改fortune
                        fortune.setWithdrawedId(withdrawId);
                        fortuneUpdates.add(fortune);
                    }
                }
            }
            if (!newFortunes.isEmpty()){
                newCustomerWithdrawMap.put(customerId,newFortunes);
            }
        }

        //批量更新需要修改的fortune记录
        customerFortuneDalService.updateBatch(fortuneUpdates);
        //重新计算受到影响的withdraw
        List<Long> withdrawUpdateIds = new ArrayList<>(customerWithdrawMap.keySet());
        recalculateWithdraw(withdrawUpdateIds);
        //更新生成新的提现记录,及支付记录,fortune中记录对应的withdraw.id
        insertWithdraw(newCustomerWithdrawMap);
    }

    private void noPaymentUpDate(String paymentStatus, Long loginId, List<AclCustomerFortune> customerFortunes) {
        //需要修改的fortune记录(需修改佣金发放状态)
        List<AclCustomerFortune> fortuneUpdates = new ArrayList<>();
        //需要重新计算的withdraw.id
        List<Long> withdrawUpdateIds = new ArrayList<>();
        for(AclCustomerFortune fortune : customerFortunes){
            //不一致,进行修改,并保存需修改的fortune和需重新计算的withdrawIds
            if (!paymentStatus.equals(fortune.getCommissionPayoutStatus())){
                fortune.setCommissionPayoutStatus(paymentStatus);
                fortune.setCommissionPayoutBy(loginId);
                fortune.setCommissionPayoutAt(new Date());
                Long withdrawId = fortune.getWithdrawedId();
                fortune.setWithdrawedId(null);
                fortuneUpdates.add(fortune);
                if (!CommonUtil.isNullOrZero(withdrawId)){
                    withdrawUpdateIds.add(withdrawId);
                }
            }
        }
        //批量更新需要修改的fortune记录
        customerFortuneDalService.updateBatch(fortuneUpdates);
        //重新计算受到影响的withdraw
        recalculateWithdraw(withdrawUpdateIds);
    }

    private void recalculateWithdraw(List<Long> withdrawUpdateIds) {
        if (withdrawUpdateIds.isEmpty()){
            return;
        }
        System.out.println("recalculateWithdraw");
//        List<AclCustomerFortune> fortunes = customerFortuneDalService.findByWithdrawIds(withdrawUpdateIds);
    }

    private void insertWithdraw(Map<Long, List<AclCustomerFortune>> newCustomerWithdrawMap) {
        if (newCustomerWithdrawMap.isEmpty()){
            return;
        }
        System.out.println("insertWithdraw");

    }


    private Map<Long, List<AclCustomerFortune>> changeCustomerFortunes(List<AclCustomerFortune> customerFortunes) {
        Map<Long, List<AclCustomerFortune>> map = new HashMap<>(16);
        for (AclCustomerFortune list: customerFortunes) {
            List<AclCustomerFortune> customerFortuneList = map.get(list.getCustomerId());
            customerFortuneList = Optional.ofNullable(customerFortuneList).orElse(new ArrayList<>());
            if (customerFortuneList.isEmpty()){
                customerFortuneList.add(list);
                map.put(list.getCustomerId(),customerFortuneList);
            }else {
                customerFortuneList.add(list);
            }
        }
        return map;
    }


    private Map<Long, List<Object>> changeList(List<Object> objList ,String name) {
        Map<Long, List<Object>> map = new HashMap<>(16);
        for (Object obj: objList) {
            List<Object> list = map.get(getFieldValueByName(name,obj));
            list = Optional.ofNullable(list).orElse(new ArrayList<>());
            if (list.isEmpty()){
                list.add(list);
                map.put(getFieldValueByName(name,obj),list);
            }else {
                list.add(list);
            }
        }
        return map;
    }

    /**
     * 根据属性名获取属性值
     * */
    private Long getFieldValueByName(String fieldName, Object o) {
        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "get" + firstLetter + fieldName.substring(1);
            Method method = o.getClass().getMethod(getter, new Class[] {});
            return (Long) method.invoke(o, new Object[] {});
        } catch (Exception e) {
            return null;
        }
    }

}
