package com.yd.dal.mapper.agms;

import com.yd.dal.entity.agms.fortune.CommissionPayoutStatus;
import com.yd.dal.entity.agms.fortune.CommissionPayoutStatusQueryInfo;
import com.yd.dal.entity.agms.fortune.CustomerFortuneStatisticalInfo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author xxy
 */
public interface AgmsFortuneMapper {
    /**
     * 通过customerid查询财富基本信息(历史累积财富  已退保财富  已提现财富 等)
     * @param customerIdList customerIds
     * @return 财富基本信息(历史累积财富  已退保财富  已提现财富 等)
     */
    List<CustomerFortuneStatisticalInfo> findFortuneStatisticalByCustomers(List<Long> customerIdList);

    /**
     * 发佣检核列表
     * @param requestVO 过滤条件
     * @return 返回结果
     */
    List<CommissionPayoutStatus> commissionPayoutStatusQuery(@Param("item") CommissionPayoutStatusQueryInfo requestVO);
}
