package com.yd.rmi.tencent.wechatinterf.service;

import com.yd.rmi.tencent.wechat.vo.accesstoken.AccessTokenByCodeRequest;
import com.yd.rmi.tencent.wechat.vo.accesstoken.AccessTokenByCodeResponse;
import com.yd.rmi.tencent.wechatinterf.pojo.accesstoken.AccessTokenRequest;
import com.yd.rmi.tencent.wechatinterf.pojo.accesstoken.AccessTokenResponse;
import com.yd.rmi.tencent.wechatinterf.pojo.authorize.AuthorizeRequest;
import com.yd.rmi.tencent.wechatinterf.pojo.jscode2session.Jscode2sessionRequest;
import com.yd.rmi.tencent.wechatinterf.pojo.jscode2session.Jscode2sessionResponse;
import com.yd.rmi.tencent.wechatinterf.pojo.templetemessage.SendTemplateRequest;
import com.yd.rmi.tencent.wechatinterf.pojo.ticket.TicketRequest;
import com.yd.rmi.tencent.wechatinterf.pojo.ticket.TicketResponse;
import com.yd.rmi.tencent.wechatinterf.pojo.token.TokenRequest;
import com.yd.rmi.tencent.wechatinterf.pojo.token.TokenResponse;
import com.yd.rmi.tencent.wechatinterf.pojo.unifiedorder.UnifiedorderResponse;

public interface WechatInterfService {
	/** 
	 * 公众号支付时网页授权
	 * 1. 获取code
	 * @param AuthorizeRequest
	 * @return
	 */
	public void authorize(AuthorizeRequest authorizeRequest);

	/**
	 * 公众号支付时网页授权，这里返回值有openid
	 * 2. 通过code换取accesstoken
	 * @param AccessTokenRequest
	 * @return
	 */
	public AccessTokenResponse accessToken(AccessTokenRequest accessTokenRequest);
	
	/**
	 * 微信分享授权第一步
	 * 获取公众号的access_token
	 * 注意这和网页授权部分的access_token不是一回事！该接口有调用次数限制，且独立（不依赖于authorize接口）
	 * @param TokenRequest
	 * @return
	 */
	public TokenResponse token(TokenRequest tokenRequest);

	/**
	 * 微信分享授权第二步
	 * 获取jsapi_ticket
	 * @param ticketRequest
	 * @return
	 */
	public TicketResponse ticket(TicketRequest ticketRequest);

	
	/**
	 * 小程序wx.login登录凭证校验,使用 临时登录凭证code 获取 session_key 和 openid 等
	 * @param jscode2sessionRequest
	 * @return Jscode2sessionResponse
	 */
	public Jscode2sessionResponse jscode2session(Jscode2sessionRequest jscode2sessionRequest);

    /**
     * 微信支付返回报文校验
     * @param unifiedorderResponse
     * @param key
     * @return
     */
	public boolean signValite(UnifiedorderResponse unifiedorderResponse);

	public String transaction(String url, String object, String object2);

	/**
	 * 微信接口交互 -- 获取access_token
	 * 获取公众号的access_token
	 * 注意这和网页授权部分的access_token不是一回事！该接口有调用次数限制，且独立（不依赖于authorize接口）
	 * @param accessTokenRequest
	 * @return
	 */
	AccessTokenResponse getAccessToken(AccessTokenRequest accessTokenRequest);

	/**
	 * 微信交互接口
	 * @param url 交互地址
	 * @param requestInfo 请求报文
	 * @return
	 */
	String weChatTransaction(String url, String requestInfo);

	/**
	 * 公众号支付时网页授权 -- 通过code获取accessToken
	 * 这里返回值包含openid
	 * @param accessTokenByCodeRequest
	 * @return
	 */
	AccessTokenByCodeResponse getAccessTokenByCode(AccessTokenByCodeRequest accessTokenByCodeRequest);

	/**
	 * 发送模版信息
	 * @param sendTemplateRequest
	 */
	void sendTemplateMessage(SendTemplateRequest sendTemplateRequest);

}
