package com.yd.dal.service.customer;

import com.yd.dal.entity.customer.AclFileUpload;
import com.yd.dal.entity.customer.CustomerFileUpload;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("aclFileUploadDALService")
public interface AclFileUploadDALService {
    /**
     * 通过ag_acl_file_upload查询用户的头像
     * @param targetType 1.经纪人，2.员工，3.客户表，4.渠道表
     * @param targetUseFor 1、头像，2、生活照，3、证照，4、毕业证书，5、营业登记证，6、质询定制方案，7、身份证正面，8、身份证方面
     * @param practitionerId 经纪人Id
     * @return 查询结果
     */
    CustomerFileUpload findFilePathInfo(Integer targetType, Integer targetUseFor, Long practitionerId);

    /**
     * 查询fileUpload信息
     * @param fileUpload
     * @return
     */
    List<AclFileUpload> findByAclFileUpload(AclFileUpload fileUpload);

    /**
     * 通过id查找ag_acl_file_upload信息
     * @param fileId
     * @return
     */
    AclFileUpload findFileUploadById(Long fileId);

    /**
     * 通过id更新ag_acl_file_upload
     * @param fileUpload
     */
    void updateFileUpload(AclFileUpload fileUpload);

    /**
     * 保存ag_acl_file_upload
     * @param aclFileUpload
     */
    void saveFileUpload(AclFileUpload aclFileUpload);

    /**
     * 根据条件查询
     * @param type 类型
     * @param targetId id
     * @param remark 备注
     * @return
     */
    AclFileUpload findByTargetIdAndRemark(Integer type, Long targetId, String remark);
}
