package com.yd.api.agms.service.impl;

import com.yd.api.agms.service.AgmsDashboardService;
import com.yd.api.agms.vo.dashboard.StatisticsOpportunityRequestVO;
import com.yd.api.agms.vo.dashboard.StatisticsOpportunityResponseVO;
import com.yd.api.agms.vo.dashboard.StatisticsPEPRequestVO;
import com.yd.api.agms.vo.dashboard.StatisticsPEPResponseVO;
import com.yd.api.result.CommonResult;
import com.yd.dal.entity.agms.dashboard.StatisticsOpportunityInfo;
import com.yd.dal.entity.agms.dashboard.StatisticsPEPInfo;
import com.yd.dal.entity.meta.MdDropOptions;
import com.yd.dal.service.agms.AgmsDashboardDALService;
import com.yd.dal.service.meta.MdDropOptionsDALService;
import com.yd.util.config.ZHBErrorConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("agmsDashboardService")
public class AgmsDashboardServiceImpl implements AgmsDashboardService {

    @Autowired
    private AgmsDashboardDALService agmsDashboardDALService;
    @Autowired
    private MdDropOptionsDALService mdDropOptionsDALService;

    @Override
    public StatisticsPEPResponseVO statisticsPEP(StatisticsPEPRequestVO requestVO) {
        //AGMS -- Dashboard查询  寿险整体运营->PEP活动管理(根据公司)
        StatisticsPEPResponseVO responseVO = new StatisticsPEPResponseVO();
        MdDropOptions mdDropOptions = mdDropOptionsDALService.selectByMasterCodeAndOptionsCode("bizchance_promotion_action","refused");
        List<StatisticsPEPInfo> statisticsPEPInfos = agmsDashboardDALService.statisticsPEP(requestVO.getType(),mdDropOptions.getId());
        responseVO.setStatisticsPEPInfos(statisticsPEPInfos);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    @Override
    public StatisticsOpportunityResponseVO statisticsOpportunity(StatisticsOpportunityRequestVO requestVO) {
        StatisticsOpportunityResponseVO responseVO = new StatisticsOpportunityResponseVO();
        MdDropOptions mdDropOptions = mdDropOptionsDALService.selectByMasterCodeAndOptionsCode("bizchance_promotion_action","refused");
        List<StatisticsOpportunityInfo> statisticsOpportunityInfos = agmsDashboardDALService.statisticsOpportunity(requestVO.getType(),requestVO.getTime(),mdDropOptions.getId());
        responseVO.setStatisticsOpportunityInfos(statisticsOpportunityInfos);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }
}
