package com.yd.api.practitioner.service;

import com.yd.api.practitioner.vo.opportunity.ApplyForExpertSupportRequestVO;
import com.yd.api.practitioner.vo.opportunity.ApplyForExpertSupportResponseVO;
import com.yd.api.practitioner.vo.payscale.PayScalePdfRequestVO;
import com.yd.api.practitioner.vo.payscale.PayScalePdfResponseVO;
import com.yd.api.practitioner.vo.payscale.PayScaleQueryRequestVO;
import com.yd.api.practitioner.vo.payscale.PayScaleQueryResponseVO;
import com.yd.api.practitioner.vo.policy.PolicyListQueryRequestVO;
import com.yd.api.practitioner.vo.policy.PolicyListQueryResponseVO;
import com.yd.api.practitioner.vo.policy.policyinfoquery.PolicyInfoQueryRequestVO;
import com.yd.api.practitioner.vo.policy.policyinfoquery.PolicyInfoQueryResponseVO;
import org.springframework.stereotype.Service;

@Service("practitionerBasicInfoService")
public interface PractitionerBasicInfoService {
    /**
     * 经纪人保单列表查询
     * @param requestVO 请求信息
     * @return PolicyListQueryResponseVO
     */
    PolicyListQueryResponseVO policyListQuery(PolicyListQueryRequestVO requestVO);

    /**
     * 经纪人保单详情查询
     * @param requestVO 请求信息
     * @return PolicyInfoQueryResponseVO
     */
    PolicyInfoQueryResponseVO policyInfoQuery(PolicyInfoQueryRequestVO requestVO);

    /**
     * eGolden -- 经纪人薪资表查询
     * @param requestVO 请求信息
     * @return 相应
     */
    PayScaleQueryResponseVO payScaleListQuery(PayScaleQueryRequestVO requestVO);

    /**
     * 获取经纪人的薪资表
     * @param requestVO 请求信息
     * @return 响应信息
     */
    PayScalePdfResponseVO payScalePdf(PayScalePdfRequestVO requestVO);

}
