package com.yd.dal.service.practitioner.impl;

import com.google.common.base.Strings;
import com.yd.dal.entity.practitioner.PractitionerBasicInfoDAL;
import com.yd.dal.entity.practitioner.PractitionerInfo;
import com.yd.dal.entity.practitioner.PractitionerRankInfo;
import com.yd.dal.mapper.practitioner.PractitionerMapper;
import com.yd.dal.service.customer.impl.CustomerDALServiceImpl;
import com.yd.dal.service.practitioner.PractitionerDALService;
import com.yd.util.intercept.annotation.TargetDataSource;
import com.yd.util.intercept.commons.DataSourceKey;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service("practitionerServiceDAL")
public class PractitionerDALServiceImpl implements PractitionerDALService {
    private static final Logger LOG = Logger.getLogger(CustomerDALServiceImpl.class);
    @Resource
    private PractitionerMapper practitionerMapper;
    @Override
    @TargetDataSource(dataSourceKey = DataSourceKey.DB_EGOLDEN)
    public PractitionerBasicInfoDAL getPractitionerBasicInfoForOffline(String mobileNo) {
        if(!Strings.isNullOrEmpty(mobileNo)){
            return practitionerMapper.getPractitionerInfoByMobileNoForOffline(mobileNo);
        }else{
            LOG.error("mobileNo is null！");
        }
        return null;
    }

    @Override
    public PractitionerBasicInfoDAL getPractitionerBasicInfoForOnline(String mobileNo) {
        if(!Strings.isNullOrEmpty(mobileNo)){
            return practitionerMapper.getPractitionerInfoByMobileNoForOnline(mobileNo);
        }else{
            LOG.error("mobileNo is null！");
        }
        return null;
    }

    @Override
    @TargetDataSource(dataSourceKey = DataSourceKey.DB_EGOLDEN)
    public List<PractitionerRankInfo> getPractitionerRankInfoForOffline(Integer time) {
        return practitionerMapper.getPractitionerRankInfoForOffline(time);
    }

    @Override
    public List<PractitionerRankInfo> getPractitionerRankInfoForOnline(Integer time,Long practitionerTypeId) {
        return practitionerMapper.getPractitionerRankInfoForOnline(time,practitionerTypeId);
    }

    @Override
    public List<PractitionerRankInfo> getPractitionerRankInfoForSpecials(List<String> mobileSpecials,Integer time) {
        return practitionerMapper.getPractitionerRankInfoForSpecials(mobileSpecials,time);
    }

    @Override
    public PractitionerInfo findPractitionerInfoByLogin(String mobileNo) {
        return practitionerMapper.findPractitionerInfoByLogin(mobileNo);
    }
}
