package com.yd.dal.service.customer;

import com.yd.dal.entity.customer.AclCustomerLog;
import com.yd.dal.mapper.customer.AclCustomerLogMapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("aclCustomerLogDALService")
public class AclCustomerLogDALService {

    @Resource
    private AclCustomerLogMapper aclCustomerLogMapper;
    public List<AclCustomerLog> findLogInfoByCustomerId(Long customerId) {
        List<AclCustomerLog> customerLogList = new ArrayList<>();
        if(customerId != null){
            customerLogList = aclCustomerLogMapper.findLogInfoByCustomerId(customerId);
        }
        return customerLogList;
    }

    /**
     * 保存用户日志
     * @param customerId 用户id
     * @param plateFlag 1-在线平台 2-经纪
     */
    public void saveCustomerLog(Long customerId, int plateFlag) {
        AclCustomerLog customerLog = new AclCustomerLog();
        customerLog.setCustomerId(customerId);
        customerLog.setFromPlateform(plateFlag);
        customerLog.setLoginTime(new Date());
        customerLog.setIsSuccess(1);
        customerLog.setCreatedAt(new Date());
        customerLog.setCreatedBy(-1L);
        aclCustomerLogMapper.insert(customerLog);
    }
}
