package com.yd.dal.service.order.Impl;

import com.yd.dal.entity.order.CustomerPolicyInfo;
import com.yd.dal.entity.order.PoOrder;
import com.yd.dal.mapper.order.PoOrderMapper;
import com.yd.dal.service.order.PoOrderDALService;
import com.yd.util.intercept.annotation.TargetDataSource;
import com.yd.util.intercept.commons.DataSourceKey;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service("poOrderDALService")
public class PoOrderDALServiceImpl implements PoOrderDALService {
    @Resource
    private PoOrderMapper poOrderMapper;

    @Override
    public List<PoOrder> findByStatusAndShareCodeInGroupByCustomerId(int status, List<String> customerShareCodes) {
        return poOrderMapper.findByStatusAndShareCodeInGroupByCustomerId(status , customerShareCodes);
    }

    @Override
    public PoOrder findByOrderId(Long orderId) {
        return poOrderMapper.selectByPrimaryKey(orderId);
    }

    @Override
    public List<CustomerPolicyInfo> findPolicyInfoByCustomerId(Long customerId, Integer time) {
        return poOrderMapper.findPolicyInfoByCustomerId(customerId,time);
    }

    @Override
    @TargetDataSource(dataSourceKey = DataSourceKey.DB_EGOLDEN)
    public List<CustomerPolicyInfo> findPolicyInfoByMobileNoE(String mobileNo, Integer time) {
        return poOrderMapper.findPolicyInfoByMobileNoE(mobileNo,time);
    }
}
