package com.yd.api.practitioner;

import com.yd.api.practitioner.service.PractitionerService;
import com.yd.api.practitioner.vo.rank.PractitionerRankRequestVO;
import com.yd.api.practitioner.vo.rank.PractitionerRankResponseVO;
import com.yd.api.result.JsonResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Controller
@RestController
public class PractitionerController {

    @Autowired
    private PractitionerService practitionerService;

    /**
     * 线下经纪人排行榜
     * @param requestVO
     * @return
     */
    @RequestMapping("/practitionerRank")
    public Object practitionerRank(@RequestBody PractitionerRankRequestVO requestVO){
        JsonResult result = new JsonResult();
        PractitionerRankResponseVO responseVO = practitionerService.practitionerRank(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

}
