package com.yd.dal.entity.customer;

import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * fortune record of customer
 */
@Data
public class AclCustomerFortune {
    private static final long serialVersionUID = 1L;
    /**
     * serial id
     */
    private Long id;

    /**
     * FK ag_acl_customer_share.id
     */
    private Long shareId;

    /**
     * FK ag_acl_customer.id
     */
    private Long customerId;

    /**
     * FK ag_po_order.id
     */
    private Long orderId;

    private Date orderDate;

    private BigDecimal orderPrice;

    /**
     * FK ag_product_plan_commission，ag_product_life_plan_commission银盾来佣佣金率
     */
    private BigDecimal commissionRate;

    /**
     * 银盾来佣佣金
     */
    private BigDecimal commissionAmount;

    /**
     * 公告佣金率存百分值
     */
    private BigDecimal fycRate;

    /**
     * 公告佣金
     */
    private BigDecimal fycAmount;

    /**
     * FK ag_acl_channel_referral_rate个人职级佣金率
     */
    private BigDecimal gradeCommissionRate;

    /**
     * 多个代理人财富分摊比例
     */
    private BigDecimal shareRate;

    /**
     * %=referral amount / order price
     */
    private BigDecimal referralRate;

    private BigDecimal referralAmount;

    /**
     * 发佣年月
     */
    private String monthPeriod;

    /**
     * 佣金类型
     */
    private String commissionType;

    /**
     * FK ag_md_drop_options.drop_option_code where master = Commission_Type,佣金项目类型编码
     */
    private String dropOptionCode;

    /**
     * 经纪人等级
     */
    private String practitionerLevel;

    /**
     * 0=No, 1=Yes
     */
    private Integer isTax;

    private BigDecimal taxAmount;

    private BigDecimal netAmount;

    /**
     * FK ag_md_mk_campaign.id
     */
    private Long campaignId;

    /**
     * 推广活动
     */
    private String campaignName;

    /**
     * 可提现日期，在生产记录时就算好
     */
    private Date withdrawableDate;

    /**
     * FK ag_acl_customer_fortune_payout_batch.id where payout_yearmonth = '2020-11-10',佣金预计发放批次
     */
    private Long payoutBatchId;

    /**
     * FK ag_md_drop_options.drop_option_code where master = Commission_Payout_Status,佣金发放状态
     */
    private String commissionPayoutStatus;

    /**
     * 发放状态修改时间
     */
    private Date commissionPayoutAt;

    /**
     * FK ag_acl_user.id
     */
    private Long commissionPayoutBy;

    /**
     * FK ag_acl_customer_fortune_withdraw.id 提现表的id
     */
    private Long withdrawedId;

    /**
     * FK ag_acl_customer_fortune_pay.id 支付表的id
     */
    private Long fortunePayedId;

    /**
     * 创建时间
     */
    private Date createdAt;

    /**
     * FK ag_acl_customer.id
     */
    private Long createdBy;
}