package com.ajb.web.metadata.impl;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ajb.car.entity.meta.Userdata;
import com.ajb.car.metadata.service.UserdataService;
import com.ajb.car.vo.common.CommonResult;
import com.ajb.car.vo.zhima.user.UserdataDeleteRequestVO;
import com.ajb.car.vo.zhima.user.UserdataRequestVO;
import com.ajb.car.vo.zhima.user.UserdataResponseVO;
import com.ajb.common.utils.encryption.MaskUtils;
import com.ajb.web.user.UserdataWebService;
/**
 * 基础资料表的处理
 * 这里是演示铭感字段的存储和读取方式
 * @author Simon Cheng
 *
 */
@Service("userdataWebService")
public class UserdataWebServiceImpl implements UserdataWebService {

	@Autowired
	private UserdataService userdataService;
	
	@Transactional
	@Override
	public UserdataResponseVO saveUserdata(UserdataRequestVO userdataRequestVO) throws Exception {
		UserdataResponseVO result =  new UserdataResponseVO();
    	//TODO validate the user inputs
		Userdata tempEntity =  new Userdata();      
	    
        //TODO validate the user inputs
        BeanUtils.copyProperties(userdataRequestVO,tempEntity);
        
		//data persistence        
    	tempEntity = userdataService.save(tempEntity);
    	      
        //return success info
		Boolean success = true;
		String message = "save success!";
		BeanUtils.copyProperties(tempEntity,userdataRequestVO);
		
		result.setCommonResult(new CommonResult(success,message));
		result.setRequestVO(userdataRequestVO);
        
        return result;
	}
    
    @Transactional
	@Override
	public  UserdataResponseVO updateUserdata(UserdataRequestVO userdataRequestVO) {
		// TODO Auto-generated method stub
				Boolean success = true;
		String message = "save success!";
		
		UserdataResponseVO result = new UserdataResponseVO();
		result.setCommonResult(new CommonResult(success,message));
		
        return result;
	}

	@Transactional
	@Override
	public  UserdataResponseVO queryUserdata(UserdataRequestVO userdataRequestVO) {
		Boolean success = true;
		String message = "save success!";
		
		Userdata tempEntity =  new Userdata();      
	    
        BeanUtils.copyProperties(userdataRequestVO,tempEntity);
        
		//data persistence        
    	tempEntity = userdataService.findById(userdataRequestVO.getId());

		UserdataResponseVO result = new UserdataResponseVO();

		BeanUtils.copyProperties(tempEntity,userdataRequestVO);
		//当输出到前端时， view object对象，铭感字段需要打上mask
		userdataRequestVO.setIdnumbermask(MaskUtils.maskIDCardNo(userdataRequestVO.getIdnumber()));
		userdataRequestVO.setTelephonemask(MaskUtils.maskCellphone(userdataRequestVO.getTelephone()));

		result.setRequestVO(userdataRequestVO);
		result.setCommonResult(new CommonResult(success,message));
		
        return result;
	}
}