package com.ajb.web;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.ajb.car.vo.common.CommonResult;
import com.ajb.car.vo.zhima.quotation.QuotationRequestVO;
import com.ajb.car.vo.zhima.quotation.QuotationResponse;
import com.ajb.car.vo.zhima.user.UserdataRequestVO;
import com.ajb.global.config.ZhimaConnection;
import com.ajb.web.zhima.ZhimaDataSyncService;

@RestController
public class DataController {

	@Autowired
	private ZhimaDataSyncService taskService;
	
	/**
	 * 同步芝麻车险报价数据
	 * @param loginRequestVO
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("/syncquotations")
	public Object synch(@RequestBody QuotationRequestVO loginRequestVO) throws Exception{	
		QuotationResponse quotationResponse = new QuotationResponse();

		try
		{
			DateFormat fmt =new SimpleDateFormat("yyyy-MM-dd");
			Date begin = fmt.parse(loginRequestVO.getBegindate());
			
			Date end = fmt.parse(loginRequestVO.getEnddate());
			
			quotationResponse = taskService.synchQuotaion(begin,end);
		}catch (Exception ex){
			quotationResponse.setCommonResult(new CommonResult(false, "Error! begindate and enddate format yyyy-MM-dd!ex:{\"begindate\":\"2018-06-10\",\"enddate\":\"2018-06-10\"}"));
			quotationResponse.setErrorCode("S01");
			quotationResponse.setErrorMessage("系统出现问题，我们正在加紧解决！");
		}finally{
		}
		quotationResponse.setCommonResult(new CommonResult(true, "Success!"));
		return quotationResponse;
	}
	/**
	 * 批处理表中的一列，多列
	 * @param userdataRequestVO
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("/encryptbatch")
	public Object query(@RequestBody UserdataRequestVO userdataRequestVO) throws Exception{
		
		return null;
	}
}
