package com.ajb.global.config;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;
 
/**
 * 通过上下文过去注入的bean instance
 * @author Simon Cheng
 *
 */
@Configuration
public class SpringContextUtil implements ApplicationContextAware {
 
    private static ApplicationContext applicationContext;
 
    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {

    	SpringContextUtil.applicationContext = applicationContext;
    }
 
    public static ApplicationContext getApplicationContext() {
        return SpringContextUtil.applicationContext;
    }
 
    public static <T> T getBean(Class<T> t) {
        return SpringContextUtil.applicationContext.getBean(t);
    }
    // 通过name获取Bean.
    public static <T> T getBean(String name) {
            T bean = (T) SpringContextUtil.applicationContext.getBean(name);
			return bean;
     }
}
