package com.ajb.car.metadata.service.impl;


import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import com.ajb.car.entity.meta.Userdata;
import com.ajb.car.metadata.repositories.UserdataRepository;
import com.ajb.car.metadata.service.UserdataService;

@Service("userdataService")
public class UserdataServiceImpl implements UserdataService{
	@Autowired
	private UserdataRepository userdataRepo;

	public Userdata save(Userdata obj){
		return userdataRepo.save(obj);
	}

	public Boolean delete(Long id) {
		try {
			userdataRepo .delete(id);
		} catch (Exception e) {
			return false;
		}
		return true;
	}

	public Userdata update(Userdata obj) {
		return userdataRepo.saveAndFlush(obj);
	}

	public Userdata findById(Long id){
		return userdataRepo.findOne(id);
	}
	
	public Page<Userdata> findByObjPageable(Userdata obj,Pageable pageable){
		ExampleMatcher matcher = ExampleMatcher.matching();
		Example<Userdata> ex = Example.of(obj, matcher); 
		return userdataRepo.findAll(ex,pageable);
	}
	
	public List<Userdata> findByObjSortable(Userdata obj,Sort sort){
		ExampleMatcher matcher = ExampleMatcher.matching();
		Example<Userdata> ex = Example.of(obj, matcher); 
		return userdataRepo.findAll(ex,sort);
	}
}