package com.ajb.car.quotation;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;

import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.ajb.car.vo.quotation.AgPoQuotationRequestVO;
import com.ajb.common.utils.encryption.MaskUtils;

@RestController
public class QuotationController {
	@Autowired
	private AgPoQuotationWebService agPoQuotationWebService;
	
	@RequestMapping(value="/quotations/{quotationId}", method=RequestMethod.GET)
	public AgPoQuotationRequestVO queryAgPoQuotation(@PathVariable String quotationId, Model model) throws Exception{				

		AgPoQuotationRequestVO quotationResponse= agPoQuotationWebService.queryAgPoQuotation(Long.valueOf(quotationId));

		quotationResponse.setCustomerMobileMask(MaskUtils.maskCellphone(quotationResponse.getCustomerMobile()));
		model.addAttribute("quotation", quotationResponse); 
		  	  
		return quotationResponse; 		
	}
}