package com.ajb.car;


import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.ajb.car.user.UserdataWebService;
import com.ajb.car.vo.common.DESCommon;
import com.ajb.car.vo.common.JsonResult;
import com.ajb.car.vo.zhima.user.UserdataRequestVO;
import com.ajb.car.vo.zhima.user.UserdataResponseVO;
import com.ajb.common.utils.encryption.DESUtils;

@RestController
@RequestMapping("/userdata")
public class UserdataController {
	@Autowired
	private UserdataWebService userdataWebService;
	
	@RequestMapping("/userdataQuery")
	public Object query(@RequestBody UserdataRequestVO userdataRequestVO) throws Exception{
		JsonResult result = new JsonResult();
		UserdataResponseVO userdataResponseVO = userdataWebService.userdataQuery(userdataRequestVO);
		result.setData(userdataResponseVO);
		return result;
	}
   
    @RequestMapping("/userdataSave")
	public Object save(@RequestBody UserdataRequestVO userdataRequestVO) throws Exception{
		JsonResult result = new JsonResult();
		UserdataResponseVO userdataResponseVO = userdataWebService.userdataSave(userdataRequestVO);
		result.setData(userdataResponseVO);
		return result;
	}
    
    @RequestMapping("/userdataUpdate")
	public Object update(@RequestBody UserdataRequestVO userdataRequestVO) throws Exception{
		JsonResult result = new JsonResult();
		UserdataResponseVO userdataResponseVO = userdataWebService.userdataUpdate(userdataRequestVO);
		result.setData(userdataResponseVO);
		return result;
	}
    
    @RequestMapping("/userdataEncrypt")
	public Object encrypt(@RequestBody DESCommon requestVO) throws Exception{
		JsonResult result = new JsonResult();
		DESUtils des;
		String resultString = "";
		try {
			des = new DESUtils("123456789", "utf-8");
			//des = new DESUtils(jpaSensitiveSetting.sensitivekey, "utf-8");
			resultString = des.encode(requestVO.getContent());
			requestVO.setEncrypted(resultString);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		result.setData(requestVO);
		return result;
	}
    @RequestMapping("/userdataDecrypt")
	public Object Decrypt(@RequestBody DESCommon requestVO) throws Exception{
		JsonResult result = new JsonResult();
		DESUtils des;
		String content = "";
		try {
			des = new DESUtils("123456789", "utf-8");
			//des = new DESUtils(jpaSensitiveSetting.sensitivekey, "utf-8");
			content = des.decode(requestVO.getEncrypted());
			requestVO.setContent(content);;
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		result.setData(requestVO);
		return result;
	}
}